/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XPathInspection
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    public SuppressIntentionAction @NotNull [] getSuppressActions(@Nullable PsiElement element) {
        XPathElement e = (XPathElement)PsiTreeUtil.getContextOfType((PsiElement)element, XPathElement.class, (boolean)false);
        SuppressIntentionAction[] suppressIntentionActionArray = ContextProvider.getContextProvider(e != null ? e : element).getQuickFixFactory().getSuppressActions(this);
        if (suppressIntentionActionArray == null) {
            XPathInspection.$$$reportNull$$$0(0);
        }
        return suppressIntentionActionArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            XPathInspection.$$$reportNull$$$0(1);
        }
        return ContextProvider.getContextProvider(element.getContainingFile()).getQuickFixFactory().isSuppressedFor(element, this);
    }

    protected abstract Visitor createVisitor(InspectionManager var1, boolean var2);

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Language language;
        if (file == null) {
            XPathInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            XPathInspection.$$$reportNull$$$0(3);
        }
        if (!this.acceptsLanguage(language = file.getLanguage())) {
            return null;
        }
        Visitor visitor = this.createVisitor(manager, isOnTheFly);
        file.accept((PsiElementVisitor)visitor);
        return visitor.getProblems();
    }

    protected abstract boolean acceptsLanguage(Language var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/validation/inspections/XPathInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/XPathInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class Visitor
    extends PsiRecursiveElementVisitor {
        protected final InspectionManager myManager;
        protected boolean myOnTheFly;
        private SmartList<ProblemDescriptor> myProblems;

        Visitor(InspectionManager manager, boolean isOnTheFly) {
            this.myManager = manager;
            this.myOnTheFly = isOnTheFly;
        }

        public void visitElement(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitElement(psiElement);
            if (this.myProblems != null) {
                TextRange textRange = psiElement.getTextRange();
                for (ProblemDescriptor problem : this.myProblems) {
                    if (!textRange.contains(problem.getPsiElement().getTextRange())) continue;
                    return;
                }
            }
            if (psiElement instanceof XPathExpression) {
                this.checkExpression((XPathExpression)psiElement);
            } else if (psiElement instanceof XPathNodeTest) {
                this.checkNodeTest((XPathNodeTest)psiElement);
            } else if (psiElement instanceof XPathPredicate) {
                this.checkPredicate((XPathPredicate)psiElement);
            }
        }

        protected void checkExpression(XPathExpression expression) {
        }

        protected void checkPredicate(XPathPredicate predicate) {
        }

        protected void checkNodeTest(XPathNodeTest nodeTest) {
        }

        private ProblemDescriptor @Nullable [] getProblems() {
            return this.myProblems == null ? null : (ProblemDescriptor[])this.myProblems.toArray((Object[])ProblemDescriptor.EMPTY_ARRAY);
        }

        void addProblem(ProblemDescriptor problem) {
            if (this.myProblems == null) {
                this.myProblems = new SmartList();
            }
            this.myProblems.add((Object)problem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/lang/xpath/validation/inspections/XPathInspection$Visitor", "visitElement"));
        }
    }
}

