/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.ClassDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\n\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "FileWithMetadata", "decompiler-to-file-stubs"})
public class KotlinMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final Function2<VirtualFile, byte[], FileWithMetadata> readFile;

    public KotlinMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function2<? super VirtualFile, ? super byte[], ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, (String)"readFile");
        this.version = version;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }

    public int getStubVersion() {
        return 26 + this.version;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        VirtualFile virtualFile = content2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"content.file");
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unexpected file type " + virtualFile2.getFileType();
            throw new AssertionError((Object)string);
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"content.content");
        FileWithMetadata fileWithMetadata = (FileWithMetadata)this.readFile.invoke((Object)virtualFile2, (Object)byArray);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata file = fileWithMetadata;
        FileWithMetadata fileWithMetadata2 = file;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            ProtoBuf.Package packageProto = ((FileWithMetadata.Compatible)file).getProto().getPackage();
            FqName packageFqName = ((FileWithMetadata.Compatible)file).getPackageFqName();
            NameResolverImpl nameResolver = ((FileWithMetadata.Compatible)file).getNameResolver();
            ClsStubBuilderComponents components2 = new ClsStubBuilderComponents(new ProtoBasedClassDataFinder(((FileWithMetadata.Compatible)file).getProto(), nameResolver, ((FileWithMetadata.Compatible)file).getVersion(), null, 8, null), new AnnotationLoaderForStubBuilderImpl((SerializerExtensionProtocol)this.serializerProtocol.invoke()), virtualFile2);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components2.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            StubElement stubElement = (StubElement)fileStub;
            ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, context.getNameResolver(), context.getTypeTable(), null);
            Intrinsics.checkNotNullExpressionValue((Object)packageProto, (String)"packageProto");
            CallableClsStubBuilderKt.createPackageDeclarationsStubs((StubElement<? extends PsiElement>)stubElement, context, package_, packageProto);
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file).getClassesToDecompile()) {
                ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)((StubElement)fileStub), classProto, nameResolver, NameResolverUtilKt.getClassId(nameResolver, classProto.getFqName()), null, context);
            }
            return fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "", "()V", "Compatible", "Incompatible", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "decompiler-to-file-stubs"})
    public static abstract class FileWithMetadata {
        private FileWithMetadata() {
        }

        public /* synthetic */ FileWithMetadata(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "version", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "decompiler-to-file-stubs"})
        public static final class Incompatible
        extends FileWithMetadata {
            @NotNull
            private final BinaryVersion version;

            public Incompatible(@NotNull BinaryVersion version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                super(null);
                this.version = version;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "version", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "classesToDecompile", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getClassesToDecompile", "()Ljava/util/List;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "decompiler-to-file-stubs"})
        public static class Compatible
        extends FileWithMetadata {
            @NotNull
            private final ProtoBuf.PackageFragment proto;
            @NotNull
            private final BinaryVersion version;
            @NotNull
            private final NameResolverImpl nameResolver;
            @NotNull
            private final FqName packageFqName;
            @NotNull
            private final List<ProtoBuf.Class> classesToDecompile;

            /*
             * WARNING - void declaration
             */
            public Compatible(@NotNull ProtoBuf.PackageFragment proto, @NotNull BinaryVersion version, @NotNull SerializerExtensionProtocol serializerProtocol) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
                super(null);
                this.proto = proto;
                this.version = version;
                ProtoBuf.StringTable stringTable = this.proto.getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"proto.strings");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"proto.qualifiedNames");
                this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
                Integer n = this.proto.getPackage().getExtension(serializerProtocol.getPackageFqName());
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"proto.`package`.getExten\u2026erProtocol.packageFqName)");
                this.packageFqName = new FqName(this.nameResolver.getPackageFqName(((Number)n).intValue()));
                List<ProtoBuf.Class> list = this.proto.getClass_List();
                Intrinsics.checkNotNullExpressionValue(list, (String)"proto.class_List");
                Iterable iterable = list;
                Compatible compatible = this;
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProtoBuf.Class proto2 = (ProtoBuf.Class)element$iv$iv;
                    boolean bl = false;
                    ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, proto2.getFqName());
                    if (!(!classId.isNestedClass() && !ClassDeserializer.Companion.getBLACK_LIST().contains(classId))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                compatible.classesToDecompile = (List)destination$iv$iv;
            }

            @NotNull
            public final ProtoBuf.PackageFragment getProto() {
                return this.proto;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }

            @NotNull
            public final NameResolverImpl getNameResolver() {
                return this.nameResolver;
            }

            @NotNull
            public final FqName getPackageFqName() {
                return this.packageFqName;
            }

            @NotNull
            public List<ProtoBuf.Class> getClassesToDecompile() {
                return this.classesToDecompile;
            }
        }
    }
}

