/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.SmartList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Future;
import org.jetbrains.org.objectweb.asm.ClassReader;

public final class Callbacks {
    public static ConstantRef createConstantReference(final String ownerClass, final String fieldName, final String descriptor) {
        return new ConstantRef(){

            @Override
            public String getOwner() {
                return ownerClass;
            }

            @Override
            public String getName() {
                return fieldName;
            }

            @Override
            public String getDescriptor() {
                return descriptor;
            }
        };
    }

    @Deprecated
    public static interface ConstantAffectionResolver {
        public Future<ConstantAffection> request(String var1, String var2, int var3, boolean var4, boolean var5);
    }

    public static class ConstantAffection {
        public static final ConstantAffection EMPTY = new ConstantAffection();
        private final boolean myKnown;
        private final Collection<File> myAffectedFiles;

        public ConstantAffection(Collection<File> affectedFiles) {
            this.myAffectedFiles = affectedFiles;
            this.myKnown = true;
        }

        public ConstantAffection() {
            this.myKnown = false;
            this.myAffectedFiles = null;
        }

        public boolean isKnown() {
            return this.myKnown;
        }

        public Collection<File> getAffectedFiles() {
            return this.myAffectedFiles;
        }

        public static ConstantAffection compose(Collection<? extends ConstantAffection> affections) {
            if (affections.isEmpty()) {
                return new ConstantAffection(Collections.emptyList());
            }
            if (affections.size() == 1) {
                return affections.iterator().next();
            }
            for (ConstantAffection constantAffection : affections) {
                if (constantAffection.isKnown()) continue;
                return EMPTY;
            }
            SmartList affected = new SmartList();
            for (ConstantAffection constantAffection : affections) {
                affected.addAll(constantAffection.getAffectedFiles());
            }
            return new ConstantAffection((Collection<File>)affected);
        }
    }

    public static interface Backend {
        default public void associate(String classFileName, String sourceFileName, ClassReader cr) {
            this.associate(classFileName, Collections.singleton(sourceFileName), cr);
        }

        default public void associate(String classFileName, Collection<String> sources, ClassReader cr) {
            this.associate(classFileName, sources, cr, false);
        }

        public void associate(String var1, Collection<String> var2, ClassReader var3, boolean var4);

        public void registerImports(String var1, Collection<String> var2, Collection<String> var3);

        public void registerConstantReferences(String var1, Collection<ConstantRef> var2);
    }

    public static interface ConstantRef {
        public String getOwner();

        public String getName();

        public String getDescriptor();
    }
}

