/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.resolver;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.BuildTreeScopedCache;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.vcs.git.internal.GitVersionRef;
import org.gradle.vcs.internal.VersionControlRepositoryConnection;
import org.gradle.vcs.internal.VersionRef;

public class PersistentVcsMetadataCache
implements Stoppable {
    private static final VersionRefSerializer VALUE_SERIALIZER = new VersionRefSerializer();
    private final PersistentCache cache;
    private final PersistentIndexedCache<String, VersionRef> workingDirCache;

    public PersistentVcsMetadataCache(BuildTreeScopedCache scopedCache) {
        this.cache = scopedCache.cache("vcsMetadata").withDisplayName("VCS metadata").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
        this.workingDirCache = this.cache.createCache("workingDirs", String.class, VALUE_SERIALIZER);
    }

    @Override
    public void stop() {
        this.cache.close();
    }

    @Nullable
    public VersionRef getVersionForSelector(final VersionControlRepositoryConnection repository, final VersionConstraint constraint) {
        return this.cache.useCache(new Factory<VersionRef>(){

            @Override
            @Nullable
            public VersionRef create() {
                return (VersionRef)PersistentVcsMetadataCache.this.workingDirCache.getIfPresent(PersistentVcsMetadataCache.this.constraintCacheKey(repository, constraint));
            }
        });
    }

    public void putVersionForSelector(VersionControlRepositoryConnection repository, VersionConstraint constraint, VersionRef selectedVersion) {
        this.cache.useCache(() -> this.workingDirCache.put(this.constraintCacheKey(repository, constraint), selectedVersion));
    }

    private String constraintCacheKey(VersionControlRepositoryConnection repository, VersionConstraint constraint) {
        if (constraint.getBranch() != null) {
            return repository.getUniqueId() + ":b:" + constraint.getBranch();
        }
        return repository.getUniqueId() + ":v:" + constraint.getRequiredVersion();
    }

    private static class VersionRefSerializer
    implements Serializer<VersionRef> {
        private VersionRefSerializer() {
        }

        @Override
        public void write(Encoder encoder, VersionRef value) throws Exception {
            GitVersionRef gitRef = (GitVersionRef)value;
            encoder.writeString(gitRef.getVersion());
            encoder.writeString(gitRef.getCanonicalId());
        }

        @Override
        public VersionRef read(Decoder decoder) throws Exception {
            String version = decoder.readString();
            String canonicalId = decoder.readString();
            return GitVersionRef.from(version, canonicalId);
        }
    }
}

