/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Cast;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VcsMappings;
import org.gradle.vcs.internal.VcsMappingsStore;

public class DefaultVcsMappings
implements VcsMappings {
    private final VcsMappingsStore vcsMappings;
    private final Gradle gradle;
    private final NotationParser<Object, ModuleIdentifier> notationParser;
    private final Object lock = new Object();

    @Inject
    public DefaultVcsMappings(VcsMappingsStore vcsMappings, Gradle gradle, NotationParser<Object, ModuleIdentifier> notationParser) {
        this.vcsMappings = vcsMappings;
        this.gradle = gradle;
        this.notationParser = notationParser;
    }

    @Override
    public VcsMappings all(Action<? super VcsMapping> rule) {
        this.vcsMappings.addRule(new DslAccessRule(rule, this.lock), this.gradle);
        return this;
    }

    @Override
    public VcsMappings withModule(String module, Action<? super VcsMapping> rule) {
        this.vcsMappings.addRule(new ModuleFilteredRule(this.notationParser.parseNotation(module), new DslAccessRule(rule, this.lock)), this.gradle);
        return this;
    }

    private static class ModuleFilteredRule
    implements Action<VcsMapping> {
        private final ModuleIdentifier moduleIdentifier;
        private final Action<? super VcsMapping> delegate;

        private ModuleFilteredRule(ModuleIdentifier moduleIdentifier, Action<? super VcsMapping> delegate) {
            this.moduleIdentifier = moduleIdentifier;
            this.delegate = delegate;
        }

        @Override
        public void execute(VcsMapping mapping) {
            ModuleComponentSelector moduleComponentSelector;
            if (mapping.getRequested() instanceof ModuleComponentSelector && this.moduleIdentifier.equals((moduleComponentSelector = (ModuleComponentSelector)Cast.uncheckedCast(mapping.getRequested())).getModuleIdentifier())) {
                this.delegate.execute(mapping);
            }
        }
    }

    private static class DslAccessRule
    implements Action<VcsMapping> {
        private final Object lock;
        private final Action<? super VcsMapping> delegate;

        DslAccessRule(Action<? super VcsMapping> delegate, Object lock) {
            this.lock = lock;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(VcsMapping vcsMapping) {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.execute(vcsMapping);
            }
        }
    }
}

