/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.impldep.com.google.common.collect.HashBasedTable;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.com.google.common.collect.Table;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.plugins.ide.internal.resolver.GradleApiSourcesResolver;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;

public class IdeDependencySet {
    private final DependencyHandler dependencyHandler;
    private final JavaModuleDetector javaModuleDetector;
    private final Collection<Configuration> plusConfigurations;
    private final Collection<Configuration> minusConfigurations;
    private final boolean inferModulePath;
    private final GradleApiSourcesResolver gradleApiSourcesResolver;
    private static final Spec<ComponentIdentifier> NOT_A_MODULE = new Spec<ComponentIdentifier>(){

        @Override
        public boolean isSatisfiedBy(ComponentIdentifier id) {
            return !(id instanceof ModuleComponentIdentifier);
        }
    };

    public IdeDependencySet(DependencyHandler dependencyHandler, JavaModuleDetector javaModuleDetector, Collection<Configuration> plusConfigurations, Collection<Configuration> minusConfigurations, boolean inferModulePath, GradleApiSourcesResolver gradleApiSourcesResolver) {
        this.dependencyHandler = dependencyHandler;
        this.javaModuleDetector = javaModuleDetector;
        this.plusConfigurations = plusConfigurations;
        this.minusConfigurations = minusConfigurations;
        this.inferModulePath = inferModulePath;
        this.gradleApiSourcesResolver = gradleApiSourcesResolver;
    }

    public void visit(IdeDependencyVisitor visitor) {
        if (this.plusConfigurations.isEmpty()) {
            return;
        }
        new IdeDependencyResult().visit(visitor);
    }

    private class IdeDependencyResult {
        private final Map<ComponentArtifactIdentifier, ResolvedArtifactResult> resolvedArtifacts = Maps.newLinkedHashMap();
        private final SetMultimap<ComponentArtifactIdentifier, Configuration> configurations = MultimapBuilder.hashKeys().linkedHashSetValues().build();
        private final Map<ComponentSelector, UnresolvedDependencyResult> unresolvedDependencies = Maps.newLinkedHashMap();
        private final Table<ModuleComponentIdentifier, Class<? extends Artifact>, Set<ResolvedArtifactResult>> auxiliaryArtifacts = HashBasedTable.create();

        private IdeDependencyResult() {
        }

        public void visit(IdeDependencyVisitor visitor) {
            this.resolvePlusConfigurations(visitor);
            this.resolveMinusConfigurations(visitor);
            this.resolveAuxiliaryArtifacts(visitor);
            this.visitArtifacts(visitor);
            this.visitUnresolvedDependencies(visitor);
        }

        private void resolvePlusConfigurations(IdeDependencyVisitor visitor) {
            for (Configuration configuration2 : IdeDependencySet.this.plusConfigurations) {
                ArtifactCollection artifacts2 = this.getResolvedArtifacts(configuration2, visitor);
                for (ResolvedArtifactResult resolvedArtifact : artifacts2) {
                    this.resolvedArtifacts.put(resolvedArtifact.getId(), resolvedArtifact);
                    this.configurations.put((Object)resolvedArtifact.getId(), (Object)configuration2);
                }
                if (artifacts2.getFailures().isEmpty()) continue;
                for (UnresolvedDependencyResult unresolvedDependency : this.getUnresolvedDependencies(configuration2, visitor)) {
                    this.unresolvedDependencies.put(unresolvedDependency.getAttempted(), unresolvedDependency);
                }
            }
        }

        private void resolveMinusConfigurations(IdeDependencyVisitor visitor) {
            for (Configuration configuration2 : IdeDependencySet.this.minusConfigurations) {
                ArtifactCollection artifacts2 = this.getResolvedArtifacts(configuration2, visitor);
                for (ResolvedArtifactResult resolvedArtifact : artifacts2) {
                    this.resolvedArtifacts.remove(resolvedArtifact.getId());
                    this.configurations.removeAll((Object)resolvedArtifact.getId());
                }
                if (artifacts2.getFailures().isEmpty()) continue;
                for (UnresolvedDependencyResult unresolvedDependency : this.getUnresolvedDependencies(configuration2, visitor)) {
                    this.unresolvedDependencies.remove(unresolvedDependency.getAttempted());
                }
            }
        }

        private ArtifactCollection getResolvedArtifacts(Configuration configuration2, final IdeDependencyVisitor visitor) {
            return configuration2.getIncoming().artifactView((Action<? super ArtifactView.ViewConfiguration>)new Action<ArtifactView.ViewConfiguration>(){

                @Override
                public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                    viewConfiguration.lenient(true);
                    viewConfiguration.componentFilter(IdeDependencyResult.this.getComponentFilter(visitor));
                }
            }).getArtifacts();
        }

        private Spec<ComponentIdentifier> getComponentFilter(IdeDependencyVisitor visitor) {
            return visitor.isOffline() ? NOT_A_MODULE : Specs.satisfyAll();
        }

        private Iterable<UnresolvedDependencyResult> getUnresolvedDependencies(Configuration configuration2, IdeDependencyVisitor visitor) {
            if (visitor.isOffline()) {
                return Collections.emptySet();
            }
            return Iterables.filter(configuration2.getIncoming().getResolutionResult().getRoot().getDependencies(), UnresolvedDependencyResult.class);
        }

        private void resolveAuxiliaryArtifacts(IdeDependencyVisitor visitor) {
            if (visitor.isOffline()) {
                return;
            }
            Set<ModuleComponentIdentifier> componentIdentifiers = this.getModuleComponentIdentifiers();
            if (componentIdentifiers.isEmpty()) {
                return;
            }
            List<Class<? extends Artifact>> types = this.getAuxiliaryArtifactTypes(visitor);
            if (types.isEmpty()) {
                return;
            }
            ArtifactResolutionResult result2 = IdeDependencySet.this.dependencyHandler.createArtifactResolutionQuery().forComponents(componentIdentifiers).withArtifacts(JvmLibrary.class, types).execute();
            for (ComponentArtifactsResult artifactsResult : result2.getResolvedComponents()) {
                for (Class<? extends Artifact> type : types) {
                    LinkedHashSet resolvedArtifactResults = Sets.newLinkedHashSet();
                    for (ArtifactResult artifactResult : artifactsResult.getArtifacts(type)) {
                        if (!(artifactResult instanceof ResolvedArtifactResult)) continue;
                        resolvedArtifactResults.add((ResolvedArtifactResult)artifactResult);
                    }
                    this.auxiliaryArtifacts.put((Object)((ModuleComponentIdentifier)artifactsResult.getId()), type, (Object)resolvedArtifactResults);
                }
            }
        }

        private Set<ModuleComponentIdentifier> getModuleComponentIdentifiers() {
            LinkedHashSet componentIdentifiers = Sets.newLinkedHashSet();
            for (ComponentArtifactIdentifier identifier : this.resolvedArtifacts.keySet()) {
                ComponentIdentifier componentIdentifier = identifier.getComponentIdentifier();
                if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
                componentIdentifiers.add((ModuleComponentIdentifier)componentIdentifier);
            }
            return componentIdentifiers;
        }

        private List<Class<? extends Artifact>> getAuxiliaryArtifactTypes(IdeDependencyVisitor visitor) {
            ArrayList types = Lists.newArrayListWithCapacity((int)2);
            if (visitor.downloadSources()) {
                types.add(SourcesArtifact.class);
            }
            if (visitor.downloadJavaDoc()) {
                types.add(JavadocArtifact.class);
            }
            return types;
        }

        private void visitArtifacts(IdeDependencyVisitor visitor) {
            for (ResolvedArtifactResult artifact : this.resolvedArtifacts.values()) {
                ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
                boolean testOnly = this.isTestConfiguration(this.configurations.get((Object)artifact.getId()));
                boolean asModule = this.isModule(testOnly, artifact.getFile());
                if (componentIdentifier instanceof ProjectComponentIdentifier) {
                    visitor.visitProjectDependency(artifact, asModule);
                    continue;
                }
                if (componentIdentifier instanceof ModuleComponentIdentifier) {
                    Set<ResolvedArtifactResult> sources = (Set<ResolvedArtifactResult>)this.auxiliaryArtifacts.get((Object)componentIdentifier, SourcesArtifact.class);
                    sources = sources != null ? sources : Collections.emptySet();
                    Set<ResolvedArtifactResult> javaDoc = (Set<ResolvedArtifactResult>)this.auxiliaryArtifacts.get((Object)componentIdentifier, JavadocArtifact.class);
                    javaDoc = javaDoc != null ? javaDoc : Collections.emptySet();
                    visitor.visitModuleDependency(artifact, sources, javaDoc, testOnly, asModule);
                    continue;
                }
                if (this.isLocalGroovyDependency(artifact)) {
                    File localGroovySources = this.shouldDownloadSources(visitor) ? IdeDependencySet.this.gradleApiSourcesResolver.resolveLocalGroovySources(artifact.getFile().getName()) : null;
                    visitor.visitGradleApiDependency(artifact, localGroovySources, testOnly);
                    continue;
                }
                visitor.visitFileDependency(artifact, testOnly);
            }
        }

        private boolean isModule(boolean testOnly, File artifact) {
            return IdeDependencySet.this.javaModuleDetector.isModule(IdeDependencySet.this.inferModulePath && !testOnly, artifact);
        }

        private boolean isLocalGroovyDependency(ResolvedArtifactResult artifact) {
            String artifactFileName = artifact.getFile().getName();
            String componentIdentifier = artifact.getId().getComponentIdentifier().getDisplayName();
            return (componentIdentifier.equals(DependencyFactory.ClassPathNotation.GRADLE_API.displayName) || componentIdentifier.equals(DependencyFactory.ClassPathNotation.GRADLE_TEST_KIT.displayName) || componentIdentifier.equals(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.displayName)) && artifactFileName.startsWith("groovy-");
        }

        private boolean shouldDownloadSources(IdeDependencyVisitor visitor) {
            return !visitor.isOffline() && visitor.downloadSources();
        }

        private boolean isTestConfiguration(Set<Configuration> configurations) {
            for (Configuration c : configurations) {
                if (c.getName().toLowerCase().contains("test")) continue;
                return false;
            }
            return true;
        }

        private void visitUnresolvedDependencies(IdeDependencyVisitor visitor) {
            for (UnresolvedDependencyResult unresolvedDependency : this.unresolvedDependencies.values()) {
                visitor.visitUnresolvedDependency(unresolvedDependency);
            }
        }
    }
}

