/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;

public abstract class CompositeDynamicObject
extends AbstractDynamicObject {
    private static final DynamicObject[] NONE = new DynamicObject[0];
    private DynamicObject[] objects = NONE;
    private DynamicObject[] updateObjects = NONE;

    protected void setObjects(DynamicObject ... objects) {
        this.objects = objects;
        this.updateObjects = objects;
    }

    protected void setObjectsForUpdate(DynamicObject ... objects) {
        this.updateObjects = objects;
    }

    @Override
    public boolean hasProperty(String name) {
        for (DynamicObject object : this.objects) {
            if (!object.hasProperty(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DynamicInvokeResult tryGetProperty(String name) {
        for (DynamicObject object : this.objects) {
            DynamicInvokeResult result2 = object.tryGetProperty(name);
            if (!result2.isFound()) continue;
            return result2;
        }
        return DynamicInvokeResult.notFound();
    }

    @Override
    public DynamicInvokeResult trySetProperty(String name, Object value) {
        for (DynamicObject object : this.updateObjects) {
            DynamicInvokeResult result2 = object.trySetProperty(name, value);
            if (!result2.isFound()) continue;
            return result2;
        }
        return DynamicInvokeResult.notFound();
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = this.objects.length - 1; i >= 0; --i) {
            DynamicObject object = this.objects[i];
            properties.putAll(object.getProperties());
        }
        properties.put("properties", properties);
        return properties;
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        for (DynamicObject object : this.objects) {
            if (!object.hasMethod(name, arguments)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        for (DynamicObject object : this.objects) {
            DynamicInvokeResult result2 = object.tryInvokeMethod(name, arguments);
            if (!result2.isFound()) continue;
            return result2;
        }
        return DynamicInvokeResult.notFound();
    }
}

