/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.internal.TaskInternal;
import org.gradle.composite.internal.BuildControllers;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.DefaultBuildControllers;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.buildtree.BuildTreeWorkGraph;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.taskgraph.CalculateTreeTaskGraphBuildOperationType;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultIncludedBuildTaskGraph
implements BuildTreeWorkGraphController,
Closeable {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildStateRegistry buildRegistry;
    private final WorkerLeaseService workerLeaseService;
    private final ManagedExecutor executorService;
    private final ThreadLocal<DefaultBuildTreeWorkGraph> current = new ThreadLocal();

    public DefaultIncludedBuildTaskGraph(ExecutorFactory executorFactory, BuildOperationExecutor buildOperationExecutor, BuildStateRegistry buildRegistry, WorkerLeaseService workerLeaseService) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildRegistry = buildRegistry;
        this.executorService = executorFactory.create("included builds");
        this.workerLeaseService = workerLeaseService;
    }

    private DefaultBuildControllers createControllers() {
        return new DefaultBuildControllers(this.executorService, this.workerLeaseService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withNewWorkGraph(Function<? super BuildTreeWorkGraph, T> action) {
        DefaultBuildTreeWorkGraph previous = this.current.get();
        DefaultBuildTreeWorkGraph workGraph = new DefaultBuildTreeWorkGraph();
        this.current.set(workGraph);
        try {
            T t;
            try {
                t = action.apply(workGraph);
                workGraph.close();
            }
            catch (Throwable throwable) {
                workGraph.close();
                throw throwable;
            }
            return t;
        }
        finally {
            this.current.set(previous);
        }
    }

    @Override
    public IncludedBuildTaskResource locateTask(TaskIdentifier taskIdentifier) {
        return this.withState(workGraph -> {
            BuildState build = this.buildRegistry.getBuild(taskIdentifier.getBuildIdentifier());
            ExportedTaskNode taskNode = build.getWorkGraph().locateTask(taskIdentifier);
            return new TaskBackedResource((DefaultBuildTreeWorkGraph)workGraph, build, taskNode);
        });
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable(this.executorService);
    }

    private <T> T withState(Function<DefaultBuildTreeWorkGraph, T> action) {
        DefaultBuildTreeWorkGraph workGraph = this.current.get();
        if (workGraph == null) {
            throw new IllegalStateException("No work graph available for this thread.");
        }
        workGraph.assertIsOwner();
        return action.apply(workGraph);
    }

    private static class TaskBackedResource
    implements IncludedBuildTaskResource {
        private final DefaultBuildTreeWorkGraph workGraph;
        private final BuildState build;
        private final ExportedTaskNode taskNode;

        public TaskBackedResource(DefaultBuildTreeWorkGraph workGraph, BuildState build, ExportedTaskNode taskNode) {
            this.workGraph = workGraph;
            this.build = build;
            this.taskNode = taskNode;
        }

        @Override
        public void queueForExecution() {
            this.workGraph.queueForExecution(this.build, this.taskNode);
        }

        @Override
        public TaskInternal getTask() {
            return this.taskNode.getTask();
        }

        @Override
        public IncludedBuildTaskResource.State getTaskState() {
            return this.taskNode.getTaskState();
        }
    }

    private class DefaultBuildTreeWorkGraph
    implements BuildTreeWorkGraph,
    AutoCloseable {
        private final Thread owner;
        private final BuildControllers controllers;
        private State state = State.NotPrepared;

        public DefaultBuildTreeWorkGraph() {
            this.owner = Thread.currentThread();
            this.controllers = DefaultIncludedBuildTaskGraph.this.createControllers();
        }

        public void queueForExecution(BuildState build, ExportedTaskNode taskNode) {
            this.assertIsOwner();
            this.assertCanQueueTask();
            this.controllers.getBuildController(build).queueForExecution(taskNode);
        }

        @Override
        public void scheduleWork(final Consumer<? super BuildTreeWorkGraph.Builder> action) {
            this.assertIsOwner();
            this.expectInState(State.NotPrepared);
            this.state = State.Preparing;
            DefaultIncludedBuildTaskGraph.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                @Override
                public void run(BuildOperationContext context) {
                    action.accept(new DefaultBuildTreeWorkGraphBuilder(DefaultBuildTreeWorkGraph.this));
                    DefaultBuildTreeWorkGraph.this.controllers.populateWorkGraphs();
                    context.setResult(new CalculateTreeTaskGraphBuildOperationType.Result(){});
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Calculate build tree task graph").details(new CalculateTreeTaskGraphBuildOperationType.Details(){});
                }
            });
            this.state = State.ReadyToRun;
        }

        @Override
        public ExecutionResult<Void> runWork() {
            this.assertIsOwner();
            this.expectInState(State.ReadyToRun);
            this.state = State.Running;
            try {
                this.controllers.startExecution();
                ExecutionResult<Void> executionResult = this.controllers.awaitCompletion();
                return executionResult;
            }
            finally {
                this.state = State.Finished;
            }
        }

        @Override
        public void close() {
            this.assertIsOwner();
            this.controllers.close();
        }

        private void assertCanQueueTask() {
            this.expectInState(State.Preparing);
        }

        private void expectInState(State expectedState) {
            if (this.state != expectedState) {
                throw this.unexpectedState();
            }
        }

        private IllegalStateException unexpectedState() {
            return new IllegalStateException("Work graph is in an unexpected state: " + (Object)((Object)this.state));
        }

        private void assertIsOwner() {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException("Current thread is not the owner of this work graph.");
            }
        }
    }

    private class DefaultBuildTreeWorkGraphBuilder
    implements BuildTreeWorkGraph.Builder {
        private final DefaultBuildTreeWorkGraph owner;

        public DefaultBuildTreeWorkGraphBuilder(DefaultBuildTreeWorkGraph owner) {
            this.owner = owner;
        }

        @Override
        public void withWorkGraph(BuildState target, Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
            this.owner.controllers.getBuildController(target).populateWorkGraph(action);
        }
    }

    private static enum State {
        NotPrepared,
        Preparing,
        ReadyToRun,
        Running,
        Finished;

    }
}

