/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.Path;

public class DefaultIncludedBuild
extends AbstractCompositeParticipantBuildState
implements IncludedBuildState,
Stoppable {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;
    private final BuildState owner;
    private final IncludedBuildImpl model;

    public DefaultIncludedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner, BuildTreeState buildTree, Instantiator instantiator) {
        super(buildTree, buildDefinition.newInstance(), owner);
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
        this.owner = owner;
        this.model = instantiator.newInstance(IncludedBuildImpl.class, this);
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public File getRootDirectory() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    @Override
    public boolean isImportableBuild() {
        return !this.isImplicit;
    }

    @Override
    public IncludedBuildInternal getModel() {
        return this.model;
    }

    @Override
    public boolean isPluginBuild() {
        return this.buildDefinition.isPluginBuild();
    }

    File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public String getName() {
        return this.identityPath.getName();
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        if (this.isImplicit) {
            super.assertCanAdd(includedBuildSpec);
        }
    }

    @Override
    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildIdentifier.getName());
    }

    @Override
    public Path calculateIdentityPathForProject(Path projectPath) {
        return this.getIdentityPath().append(projectPath);
    }

    @Override
    public Action<? super DependencySubstitutions> getRegisteredDependencySubstitutions() {
        return this.buildDefinition.getDependencySubstitutions();
    }

    @Override
    public <T> T withState(Transformer<T, ? super GradleInternal> action) {
        return action.transform(this.getMutableModel());
    }

    @Override
    public ExecutionResult<Void> finishBuild() {
        return this.getBuildController().finishBuild(null);
    }

    @Override
    public void stop() {
        this.getBuildController().stop();
    }

    public static class IncludedBuildImpl
    implements IncludedBuildInternal {
        private final DefaultIncludedBuild buildState;

        public IncludedBuildImpl(DefaultIncludedBuild buildState) {
            this.buildState = buildState;
        }

        @Override
        public String getName() {
            return this.buildState.getName();
        }

        @Override
        public File getProjectDir() {
            return this.buildState.getProjectDir();
        }

        @Override
        public TaskReference task(String path) {
            Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
            return new IncludedBuildTaskReference(this.buildState, path);
        }

        @Override
        public BuildState getTarget() {
            return this.buildState;
        }
    }
}

