/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;

public class NormalizingCopyActionDecorator
implements CopyAction {
    private final CopyAction delegate;
    private final Chmod chmod;

    public NormalizingCopyActionDecorator(CopyAction delegate, Chmod chmod) {
        this.delegate = delegate;
        this.chmod = chmod;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        HashSet visitedDirs = new HashSet();
        ArrayListMultimap pendingDirs = ArrayListMultimap.create();
        return this.delegate.execute(arg_0 -> this.lambda$execute$1(stream, visitedDirs, (ListMultimap)pendingDirs, arg_0));
    }

    private void maybeVisit(RelativePath path, boolean includeEmptyDirs, CopyActionProcessingStreamAction delegateAction, Set<RelativePath> visitedDirs, ListMultimap<RelativePath, FileCopyDetailsInternal> pendingDirs) {
        if (path == null || path.getParent() == null || !visitedDirs.add(path)) {
            return;
        }
        this.maybeVisit(path.getParent(), includeEmptyDirs, delegateAction, visitedDirs, pendingDirs);
        List detailsForPath = pendingDirs.removeAll((Object)path);
        FileCopyDetailsInternal dir = detailsForPath.isEmpty() ? new StubbedFileCopyDetails(path, includeEmptyDirs, this.chmod) : (FileCopyDetailsInternal)detailsForPath.get(0);
        delegateAction.processFile(dir);
    }

    private /* synthetic */ void lambda$execute$1(CopyActionProcessingStream stream, Set visitedDirs, ListMultimap pendingDirs, CopyActionProcessingStreamAction action) {
        stream.process(details -> {
            if (details.isDirectory()) {
                RelativePath path = details.getRelativePath();
                if (!visitedDirs.contains(path)) {
                    pendingDirs.put((Object)path, (Object)details);
                }
            } else {
                this.maybeVisit(details.getRelativePath().getParent(), details.isIncludeEmptyDirs(), action, visitedDirs, (ListMultimap<RelativePath, FileCopyDetailsInternal>)pendingDirs);
                action.processFile(details);
            }
        });
        for (RelativePath path : new LinkedHashSet(pendingDirs.keySet())) {
            ArrayList detailsList = new ArrayList(pendingDirs.get((Object)path));
            for (FileCopyDetailsInternal details2 : detailsList) {
                if (!details2.isIncludeEmptyDirs()) continue;
                this.maybeVisit(path, details2.isIncludeEmptyDirs(), action, visitedDirs, (ListMultimap<RelativePath, FileCopyDetailsInternal>)pendingDirs);
            }
        }
        visitedDirs.clear();
        pendingDirs.clear();
    }

    private static class StubbedFileCopyDetails
    extends AbstractFileTreeElement
    implements FileCopyDetailsInternal {
        private final RelativePath path;
        private final boolean includeEmptyDirs;
        private long lastModified = System.currentTimeMillis();

        private StubbedFileCopyDetails(RelativePath path, boolean includeEmptyDirs, Chmod chmod) {
            super(chmod);
            this.path = path;
            this.includeEmptyDirs = includeEmptyDirs;
        }

        @Override
        public boolean isIncludeEmptyDirs() {
            return this.includeEmptyDirs;
        }

        @Override
        public String getDisplayName() {
            return this.path.toString();
        }

        @Override
        public File getFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDirectory() {
            return !this.path.isFile();
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.path;
        }

        @Override
        public void exclude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPath(String path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRelativePath(RelativePath path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMode(int mode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefaultDuplicatesStrategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourcePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativeSourcePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Closure closure) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Transformer<String, String> transformer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable expand(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
            throw new UnsupportedOperationException();
        }
    }
}

