/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.CompatibilityRuleChain;
import org.gradle.api.internal.attributes.AttributeMatchException;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.api.internal.attributes.CompatibilityCheckResult;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.internal.action.DefaultConfigurableRule;
import org.gradle.internal.action.DefaultConfigurableRules;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.type.ModelType;

public class DefaultCompatibilityRuleChain<T>
implements CompatibilityRuleChain<T>,
CompatibilityRule<T> {
    private final List<Action<? super CompatibilityCheckDetails<T>>> rules = Lists.newArrayList();
    private final Instantiator instantiator;
    private final IsolatableFactory isolatableFactory;

    public DefaultCompatibilityRuleChain(Instantiator instantiator, IsolatableFactory isolatableFactory) {
        this.instantiator = instantiator;
        this.isolatableFactory = isolatableFactory;
    }

    @Override
    public void ordered(Comparator<? super T> comparator) {
        Action<CompatibilityCheckDetails<? super T>> rule = AttributeMatchingRules.orderedCompatibility(comparator, false);
        this.rules.add(rule);
    }

    @Override
    public void reverseOrdered(Comparator<? super T> comparator) {
        Action<CompatibilityCheckDetails<? super T>> rule = AttributeMatchingRules.orderedCompatibility(comparator, true);
        this.rules.add(rule);
    }

    @Override
    public void add(Class<? extends AttributeCompatibilityRule<T>> rule, Action<? super ActionConfiguration> configureAction) {
        this.rules.add(new InstantiatingAction(DefaultConfigurableRules.of(DefaultConfigurableRule.of(rule, configureAction, this.isolatableFactory)), this.instantiator, new ExceptionHandler(rule)));
    }

    @Override
    public void add(Class<? extends AttributeCompatibilityRule<T>> rule) {
        this.rules.add(new InstantiatingAction(DefaultConfigurableRules.of(DefaultConfigurableRule.of(rule)), this.instantiator, new ExceptionHandler(rule)));
    }

    @Override
    public void execute(CompatibilityCheckResult<T> result2) {
        for (Action<CompatibilityCheckDetails<CompatibilityCheckResult<T>>> action : this.rules) {
            action.execute(result2);
            if (!result2.hasResult()) continue;
            return;
        }
    }

    @Override
    public boolean doesSomething() {
        return !this.rules.isEmpty();
    }

    private static class ExceptionHandler<T>
    implements InstantiatingAction.ExceptionHandler<CompatibilityCheckDetails<T>> {
        private final Class<? extends AttributeCompatibilityRule<T>> rule;

        private ExceptionHandler(Class<? extends AttributeCompatibilityRule<T>> rule) {
            this.rule = rule;
        }

        @Override
        public void handleException(CompatibilityCheckDetails<T> details, Throwable throwable) {
            throw new AttributeMatchException(String.format("Could not determine whether value %s is compatible with value %s using %s.", details.getProducerValue(), details.getConsumerValue(), ModelType.of(this.rule).getDisplayName()), throwable);
        }
    }
}

