/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.RepositoryAwareVerificationFailure;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.AbstractTextDependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.DependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.HtmlDependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.ReportState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.SimpleTextDependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.TextDependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationReport;
import org.gradle.api.internal.artifacts.verification.verifier.DeletedArtifact;
import org.gradle.api.internal.artifacts.verification.verifier.MissingChecksums;
import org.gradle.api.internal.artifacts.verification.verifier.SignatureVerificationFailure;
import org.gradle.api.internal.artifacts.verification.verifier.VerificationFailure;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;

public class DependencyVerificationReportWriter {
    private static final Logger LOGGER = Logging.getLogger(DependencyVerificationReportWriter.class);
    private static final Comparator<Map.Entry<ModuleComponentArtifactIdentifier, Collection<RepositoryAwareVerificationFailure>>> DELETED_LAST = Comparator.comparing(e -> ((Collection)e.getValue()).stream().anyMatch(f -> f.getFailure() instanceof DeletedArtifact) ? 1 : 0);
    private static final Comparator<Map.Entry<ModuleComponentArtifactIdentifier, Collection<RepositoryAwareVerificationFailure>>> MISSING_LAST = Comparator.comparing(e -> ((Collection)e.getValue()).stream().anyMatch(f -> f.getFailure() instanceof MissingChecksums) ? 1 : 0);
    private static final Comparator<Map.Entry<ModuleComponentArtifactIdentifier, Collection<RepositoryAwareVerificationFailure>>> BY_MODULE_ID = Comparator.comparing(e -> ((ModuleComponentArtifactIdentifier)e.getKey()).getDisplayName());
    public static final String VERBOSE_CONSOLE = "org.gradle.dependency.verification.console";
    public static final String VERBOSE_VALUE = "verbose";
    private final Path gradleUserHome;
    private Runnable rendererInitializer;
    private AbstractTextDependencyVerificationReportRenderer summaryRenderer;
    private HtmlDependencyVerificationReportRenderer htmlRenderer;

    public DependencyVerificationReportWriter(Path gradleUserHome, DocumentationRegistry documentationRegistry, File verificationFile, List<String> writeFlags, File htmlReportOutputDirectory, Factory<GradleProperties> gradlePropertiesProvider) {
        this.gradleUserHome = gradleUserHome;
        this.rendererInitializer = () -> {
            this.summaryRenderer = this.createConsoleRenderer(gradleUserHome, documentationRegistry, (GradleProperties)gradlePropertiesProvider.create());
            this.htmlRenderer = new HtmlDependencyVerificationReportRenderer(documentationRegistry, verificationFile, writeFlags, htmlReportOutputDirectory);
        };
    }

    private static boolean isVerboseConsoleReport(GradleProperties gradleProperties2) {
        try {
            String param = (String)gradleProperties2.find(VERBOSE_CONSOLE);
            return VERBOSE_VALUE.equals(param);
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Gradle properties are not loaded yet, any customization to dependency verification will be ignored until the main build script is loaded.");
            return false;
        }
    }

    private AbstractTextDependencyVerificationReportRenderer createConsoleRenderer(Path gradleUserHome, DocumentationRegistry documentationRegistry, GradleProperties gradleProperties2) {
        boolean verboseConsoleReport = DependencyVerificationReportWriter.isVerboseConsoleReport(gradleProperties2);
        if (verboseConsoleReport) {
            return new TextDependencyVerificationReportRenderer(gradleUserHome, documentationRegistry);
        }
        return new SimpleTextDependencyVerificationReportRenderer(gradleUserHome, documentationRegistry);
    }

    public VerificationReport generateReport(String displayName, Multimap<ModuleComponentArtifactIdentifier, RepositoryAwareVerificationFailure> failuresByArtifact, boolean useKeyServers) {
        this.assertInitialized();
        this.doRender(displayName, failuresByArtifact, this.summaryRenderer, useKeyServers);
        this.doRender(displayName, failuresByArtifact, this.htmlRenderer, useKeyServers);
        File htmlReport = this.htmlRenderer.writeReport();
        return new VerificationReport(this.summaryRenderer.render(), htmlReport);
    }

    public synchronized void assertInitialized() {
        if (this.rendererInitializer != null) {
            this.rendererInitializer.run();
            this.rendererInitializer = null;
        }
    }

    public void doRender(String displayName, Multimap<ModuleComponentArtifactIdentifier, RepositoryAwareVerificationFailure> failuresByArtifact, DependencyVerificationReportRenderer renderer, boolean useKeyServers) {
        ReportState reportState = new ReportState();
        if (!useKeyServers) {
            reportState.keyServersAreDisabled();
        }
        renderer.startNewSection(displayName);
        renderer.startArtifactErrors(() -> failuresByArtifact.asMap().entrySet().stream().sorted(DELETED_LAST.thenComparing(MISSING_LAST).thenComparing(BY_MODULE_ID)).forEachOrdered(entry -> {
            ModuleComponentArtifactIdentifier key = (ModuleComponentArtifactIdentifier)entry.getKey();
            Collection failures = (Collection)entry.getValue();
            this.onArtifactFailure(renderer, reportState, key, failures);
        }));
        renderer.finish(reportState);
    }

    private void onArtifactFailure(DependencyVerificationReportRenderer renderer, ReportState state2, ModuleComponentArtifactIdentifier key, Collection<RepositoryAwareVerificationFailure> failures) {
        failures.stream().map(RepositoryAwareVerificationFailure::getFailure).map(this::extractFailedFilePaths).forEach(state2::addAffectedFile);
        renderer.startNewArtifact(key, () -> {
            if (failures.size() == 1) {
                RepositoryAwareVerificationFailure firstFailure = (RepositoryAwareVerificationFailure)failures.iterator().next();
                this.explainSingleFailure(renderer, state2, firstFailure);
            } else {
                this.explainMultiFailure(renderer, state2, failures);
            }
        });
    }

    private String extractFailedFilePaths(VerificationFailure f) {
        String shortenPath = this.shortenPath(f.getFilePath());
        if (f instanceof SignatureVerificationFailure) {
            File signatureFile = ((SignatureVerificationFailure)f).getSignatureFile();
            return shortenPath + " (signature: " + this.shortenPath(signatureFile) + ")";
        }
        return shortenPath;
    }

    private String shortenPath(File file) {
        Path path = file.toPath();
        try {
            Path relativize = this.gradleUserHome.relativize(path);
            return "GRADLE_USER_HOME" + File.separator + relativize;
        }
        catch (IllegalArgumentException e) {
            return file.getAbsolutePath();
        }
    }

    private void explainMultiFailure(DependencyVerificationReportRenderer renderer, ReportState state2, Collection<RepositoryAwareVerificationFailure> failures) {
        renderer.reportAsMultipleErrors(() -> {
            for (RepositoryAwareVerificationFailure failure : failures) {
                this.explainSingleFailure(renderer, state2, failure);
            }
        });
    }

    private void explainSingleFailure(DependencyVerificationReportRenderer renderer, ReportState state2, RepositoryAwareVerificationFailure wrapper) {
        VerificationFailure failure = wrapper.getFailure();
        if (failure instanceof MissingChecksums) {
            state2.hasMissing();
        } else if (failure instanceof SignatureVerificationFailure) {
            state2.failedSignatures();
            if (((SignatureVerificationFailure)failure).getErrors().values().stream().map(SignatureVerificationFailure.SignatureError::getKind).noneMatch(kind -> kind == SignatureVerificationFailure.FailureKind.PASSED_NOT_TRUSTED)) {
                state2.maybeCompromised();
            } else {
                state2.hasUntrustedKeys();
            }
        } else {
            state2.maybeCompromised();
        }
        renderer.reportFailure(wrapper);
    }
}

