/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.plugin.management.internal.PluginRequests;

public class BuildDefinition {
    @Nullable
    private final String name;
    @Nullable
    private final File buildRootDir;
    private final StartParameterInternal startParameter;
    private final PluginRequests injectedSettingsPlugins;
    private final Action<? super DependencySubstitutions> dependencySubstitutions;
    private final PublicBuildPath fromBuild;
    private final boolean pluginBuild;

    private BuildDefinition(@Nullable String name, @Nullable File buildRootDir, StartParameterInternal startParameter, PluginRequests injectedSettingsPlugins, Action<? super DependencySubstitutions> dependencySubstitutions, PublicBuildPath fromBuild, boolean pluginBuild) {
        this.name = name;
        this.buildRootDir = buildRootDir;
        this.startParameter = startParameter;
        this.injectedSettingsPlugins = injectedSettingsPlugins;
        this.dependencySubstitutions = dependencySubstitutions;
        this.fromBuild = fromBuild;
        this.pluginBuild = pluginBuild;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public File getBuildRootDir() {
        return this.buildRootDir;
    }

    @Nullable
    public PublicBuildPath getFromBuild() {
        return this.fromBuild;
    }

    public StartParameterInternal getStartParameter() {
        return this.startParameter;
    }

    public PluginRequests getInjectedPluginRequests() {
        return this.injectedSettingsPlugins;
    }

    public Action<? super DependencySubstitutions> getDependencySubstitutions() {
        return this.dependencySubstitutions;
    }

    public boolean isPluginBuild() {
        return this.pluginBuild;
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameterInternal startParameter, String name, File buildRootDir, PluginRequests pluginRequests, Action<? super DependencySubstitutions> dependencySubstitutions, PublicBuildPath fromBuild, boolean pluginBuild) {
        return new BuildDefinition(name, buildRootDir, BuildDefinition.startParameterForIncludedBuildFrom(startParameter, buildRootDir), pluginRequests, dependencySubstitutions, fromBuild, pluginBuild);
    }

    public static BuildDefinition fromStartParameter(StartParameterInternal startParameter, @Nullable PublicBuildPath fromBuild) {
        return BuildDefinition.fromStartParameter(startParameter, null, fromBuild);
    }

    public static BuildDefinition fromStartParameter(StartParameterInternal startParameter, @Nullable File rootBuildDir, @Nullable PublicBuildPath fromBuild) {
        return new BuildDefinition(null, rootBuildDir, startParameter, PluginRequests.EMPTY, Actions.doNothing(), fromBuild, false);
    }

    private static StartParameterInternal startParameterForIncludedBuildFrom(StartParameterInternal startParameter, File buildRootDir) {
        StartParameterInternal includedBuildStartParam = startParameter.newBuild();
        includedBuildStartParam.setCurrentDir(buildRootDir);
        includedBuildStartParam.doNotSearchUpwards();
        includedBuildStartParam.setInitScripts(startParameter.getInitScripts());
        includedBuildStartParam.setExcludedTaskNames(startParameter.getExcludedTaskNames());
        return includedBuildStartParam;
    }

    public BuildDefinition newInstance() {
        return new BuildDefinition(this.name, this.buildRootDir, this.startParameter.newInstance(), this.injectedSettingsPlugins, this.dependencySubstitutions, this.fromBuild, this.pluginBuild);
    }
}

