/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models;

import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersionUtilsExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.versions.NormalizedPackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.util.VersionNameComparator;
import com.jetbrains.packagesearch.packageversionutils.PackageVersionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a$\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0004H\u0000\u001a0\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\b2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0004H\u0000\u00a8\u0006\u000b"}, d2={"getUpgradeSemanticVersionOrNull", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/versions/NormalizedPackageVersion;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "availableSemanticVersions", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/versions/NormalizedPackageVersion$Semantic;", "currentVersion", "highestSensibleVersionByNameOrNull", "Lcom/jetbrains/packagesearch/packageversionutils/PackageVersionUtils;", "availableVersions", "upgradeCandidateVersionOrNull", "intellij.packageSearch"})
public final class PackageVersionUtilsExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final NormalizedPackageVersion<?> upgradeCandidateVersionOrNull(@NotNull PackageVersionUtils $this$upgradeCandidateVersionOrNull, @NotNull NormalizedPackageVersion<?> currentVersion, @NotNull List<? extends NormalizedPackageVersion<?>> availableVersions) {
        NormalizedPackageVersion normalizedPackageVersion;
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$upgradeCandidateVersionOrNull, (String)"$this$upgradeCandidateVersionOrNull");
        Intrinsics.checkNotNullParameter(currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter(availableVersions, (String)"availableVersions");
        Collection collection = availableVersions;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            boolean $i$a$-require-PackageVersionUtilsExtensionsKt$upgradeCandidateVersionOrNull$22 = false;
            String $i$a$-require-PackageVersionUtilsExtensionsKt$upgradeCandidateVersionOrNull$22 = "Cannot find upgrades when there are no available versions";
            throw new IllegalArgumentException($i$a$-require-PackageVersionUtilsExtensionsKt$upgradeCandidateVersionOrNull$22.toString());
        }
        Iterable $this$filterIsInstance$iv = availableVersions;
        boolean $i$f$filterIsInstance2 = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NormalizedPackageVersion.Semantic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List availableSemanticVersions = CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv));
        NormalizedPackageVersion<?> normalizedPackageVersion2 = currentVersion;
        if (normalizedPackageVersion2 instanceof NormalizedPackageVersion.Semantic) {
            normalizedPackageVersion = PackageVersionUtilsExtensionsKt.getUpgradeSemanticVersionOrNull(availableSemanticVersions, (NormalizedPackageVersion.Semantic)currentVersion);
        } else {
            Collection $i$f$filterIsInstance2 = availableSemanticVersions;
            if (!$i$f$filterIsInstance2.isEmpty()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = availableSemanticVersions;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    NormalizedPackageVersion.Semantic it = (NormalizedPackageVersion.Semantic)element$iv$iv;
                    boolean bl3 = false;
                    CharSequence charSequence = it.nonSemanticSuffixOrNull();
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                normalizedPackageVersion = (NormalizedPackageVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
            } else {
                NormalizedPackageVersion normalizedPackageVersion3 = (NormalizedPackageVersion)CollectionsKt.maxOrNull((Iterable)availableVersions);
                if (normalizedPackageVersion3 != null) {
                    NormalizedPackageVersion normalizedPackageVersion4;
                    NormalizedPackageVersion it = normalizedPackageVersion4 = normalizedPackageVersion3;
                    boolean bl4 = false;
                    normalizedPackageVersion = it.compareTo(currentVersion) > 0 ? normalizedPackageVersion4 : null;
                } else {
                    normalizedPackageVersion = null;
                }
            }
        }
        return normalizedPackageVersion;
    }

    private static final NormalizedPackageVersion<? extends PackageVersion> getUpgradeSemanticVersionOrNull(List<NormalizedPackageVersion.Semantic> availableSemanticVersions, NormalizedPackageVersion.Semantic currentVersion) {
        Object v1;
        Set candidates;
        block6: {
            Object v0;
            NormalizedPackageVersion.Semantic it;
            Iterable iterable;
            Iterable iterable2;
            block5: {
                candidates = new LinkedHashSet();
                for (NormalizedPackageVersion.Semantic candidateVersion : availableSemanticVersions) {
                    int result = VersionNameComparator.INSTANCE.compare(currentVersion.getSemanticPartWithStabilityMarker(), candidateVersion.getSemanticPartWithStabilityMarker());
                    if (result == 0 || MathKt.getSign((int)result) == 1) break;
                    iterable2 = candidates;
                    iterable2.add(candidateVersion);
                }
                if (candidates.isEmpty()) {
                    return null;
                }
                String currentSuffix = currentVersion.nonSemanticSuffixOrNull();
                iterable2 = iterable = (Iterable)candidates;
                for (Object t : iterable2) {
                    it = (NormalizedPackageVersion.Semantic)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getNonSemanticSuffix(), (Object)currentSuffix)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            NormalizedPackageVersion.Semantic upgradeWithSameSuffix = v0;
            if (upgradeWithSameSuffix != null) {
                return upgradeWithSameSuffix;
            }
            iterable2 = iterable = (Iterable)candidates;
            for (Object t : iterable2) {
                it = (NormalizedPackageVersion.Semantic)t;
                boolean bl = false;
                CharSequence charSequence = it.getNonSemanticSuffix();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        NormalizedPackageVersion.Semantic semantic = v1;
        return semantic != null ? (NormalizedPackageVersion)semantic : (NormalizedPackageVersion)CollectionsKt.maxOrNull((Iterable)candidates);
    }

    @Nullable
    public static final NormalizedPackageVersion<?> highestSensibleVersionByNameOrNull(@NotNull PackageVersionUtils $this$highestSensibleVersionByNameOrNull, @NotNull List<? extends NormalizedPackageVersion<?>> availableVersions) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$highestSensibleVersionByNameOrNull, (String)"$this$highestSensibleVersionByNameOrNull");
        Intrinsics.checkNotNullParameter(availableVersions, (String)"availableVersions");
        Collection collection = availableVersions;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            boolean bl3 = false;
            String string = "Cannot find highest version in an empty list";
            throw new IllegalArgumentException(string.toString());
        }
        return (NormalizedPackageVersion)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)availableVersions), (Function1)highestSensibleVersionByNameOrNull.2.INSTANCE));
    }
}

