/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.MavenModelConverter;

public class UnresolvedArtifactsCollector {
    private final boolean myFailOnUnresolved;
    private final Set<MavenId> myUnresolvedIds = new HashSet<MavenId>();

    public UnresolvedArtifactsCollector(boolean failOnUnresolved) {
        this.myFailOnUnresolved = failOnUnresolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveUnresolvedIds(Set<MavenId> result) {
        Set<MavenId> set = this.myUnresolvedIds;
        synchronized (set) {
            result.addAll(this.myUnresolvedIds);
            this.myUnresolvedIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAndSetResolved(Artifact artifact) {
        if (!artifact.isResolved()) {
            Set<MavenId> set = this.myUnresolvedIds;
            synchronized (set) {
                this.myUnresolvedIds.add(MavenModelConverter.createMavenId(artifact));
            }
        }
        if (!this.myFailOnUnresolved) {
            artifact.setResolved(true);
        }
    }
}

