/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitMessageWithFilesDetector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GitLocalChangesWouldBeOverwrittenDetector
extends GitMessageWithFilesDetector {
    private static final Pattern OLD_CHECKOUT_PATTERN = Pattern.compile(".*You have local changes to '(.*)'; cannot switch branches.*");
    private static final Pattern OLD_MERGE_PATTERN = Pattern.compile(".*Your local changes to '(.*)' would be overwritten by merge.*");
    private static final Pattern[] RESET_PATTERNS = new Pattern[]{Pattern.compile(".*Entry '(.*)' not uptodate. Cannot merge.*"), Pattern.compile(".*Entry '(.*)' would be overwritten by merge.*")};
    public static final GitMessageWithFilesDetector.Event NEW_PATTERN = new GitMessageWithFilesDetector.Event("LocalChangesDetector", "Your local changes to the following files would be overwritten by", "commit your changes or stash them before");
    @NotNull
    private final Operation myOperation;

    public GitLocalChangesWouldBeOverwrittenDetector(@NotNull VirtualFile root, @NotNull Operation operation) {
        if (root == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(0);
        }
        if (operation == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(1);
        }
        super(NEW_PATTERN, root);
        this.myOperation = operation;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(3);
        }
        super.onLineAvailable(line, outputType);
        for (Pattern pattern : this.myOperation.getPatterns()) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            this.myMessageDetected = true;
            this.myAffectedFiles.add(m.group(1));
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onLineAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Operation {
        CHECKOUT(OLD_CHECKOUT_PATTERN),
        MERGE(OLD_MERGE_PATTERN),
        RESET(RESET_PATTERNS);

        private final Pattern @NotNull [] myPatterns;

        private Operation(Pattern ... patterns) {
            if (patterns == null) {
                Operation.$$$reportNull$$$0(0);
            }
            this.myPatterns = patterns;
        }

        Pattern @NotNull [] getPatterns() {
            if (this.myPatterns == null) {
                Operation.$$$reportNull$$$0(1);
            }
            return this.myPatterns;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector$Operation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector$Operation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

