/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/serialization/js/DynamicTypeDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "()V", "id", "", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "flexibleId", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "js.serializer"})
public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    public static final DynamicTypeDeserializer INSTANCE = new DynamicTypeDeserializer();
    @NotNull
    public static final String id = "kotlin.DynamicType";

    private DynamicTypeDeserializer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(flexibleId, "flexibleId");
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        if (!Intrinsics.areEqual(flexibleId, id)) {
            String[] stringArray = new String[]{flexibleId, lowerBound.toString(), upperBound.toString()};
            return ErrorUtils.createErrorType(ErrorTypeKind.UNEXPECTED_FLEXIBLE_TYPE_ID, stringArray);
        }
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lowerBound).getNothingType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "lowerBound.builtIns.nothingType");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound, simpleType2)) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "upperBound.builtIns.nullableAnyType");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound, simpleType3)) {
                kotlinType = DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(lowerBound));
                return kotlinType;
            }
        }
        String[] stringArray = new String[]{lowerBound.toString(), upperBound.toString()};
        kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ILLEGAL_TYPE_RANGE_FOR_DYNAMIC, stringArray);
        return kotlinType;
    }
}

