/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class UnwrapTagFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(UnwrapTagFix.class);
    private final String myTagName;

    public UnwrapTagFix(String tagName) {
        this.myTagName = tagName;
    }

    @NotNull
    public String getName() {
        String string = JavaFXBundle.message("inspection.javafx.default.tag.unwrap.tag.fix.name", this.myTagName);
        if (string == null) {
            UnwrapTagFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaFXBundle.message("inspection.javafx.default.tag.unwrap.tag.fix.family.name", new Object[0]);
        if (string == null) {
            UnwrapTagFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            UnwrapTagFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            UnwrapTagFix.$$$reportNull$$$0(3);
        }
        if ((element = descriptor.getPsiElement()) != null) {
            PsiFile containingFile = element.getContainingFile();
            LOG.assertTrue(containingFile != null && JavaFxFileTypeFactory.isFxml(containingFile), containingFile == null ? "no containing file found" : "containing file: " + containingFile.getName());
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (xmlTag != null) {
                XmlTag parentTag = xmlTag.getParentTag();
                PsiElement[] children = PsiTreeUtil.getChildrenOfType((PsiElement)xmlTag, XmlTagChild.class);
                if (children != null && children.length > 0 && parentTag != null) {
                    parentTag.addRange(children[0], children[children.length - 1]);
                }
                xmlTag.delete();
                if (parentTag != null) {
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parentTag, true);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/UnwrapTagFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/UnwrapTagFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

