/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class JavaFXVersionFactory
extends ProjectTemplateParameterFactory {
    public String getParameterId() {
        return "IJ_JAVAFX_VERSION";
    }

    @Nullable
    public WizardInputField<?> createField(String defaultValue) {
        return new WizardInputField<JComponent>(this.getParameterId(), defaultValue){

            public String getLabel() {
                return null;
            }

            public JComponent getComponent() {
                return null;
            }

            public String getValue() {
                return null;
            }

            public Map<String, String> getValues() {
                return Collections.emptyMap();
            }
        };
    }

    @Nullable
    public String detectParameterValue(Project project) {
        return null;
    }

    public void applyResult(String value, ModifiableRootModel model) {
        JavaSdkVersion version = JavaFXVersionFactory.getSdkVersion(model);
        if (version != null && version.isAtLeast(JavaSdkVersion.JDK_11)) {
            Module module = model.getModule();
            int preferredVersion = version.ordinal();
            ApplicationManager.getApplication().invokeLater(() -> {
                ExternalLibraryDescriptor libraryDescriptor = new ExternalLibraryDescriptor("org.openjfx", "javafx-fxml", "11", null, String.valueOf(preferredVersion));
                JavaProjectModelModificationService.getInstance((Project)module.getProject()).addDependency(module, libraryDescriptor, DependencyScope.COMPILE);
            }, module.getDisposed());
        }
    }

    @Nullable
    private static JavaSdkVersion getSdkVersion(ModifiableRootModel model) {
        SdkTypeId type;
        Sdk sdk = ProjectRootManager.getInstance((Project)model.getProject()).getProjectSdk();
        if (sdk != null && (type = sdk.getSdkType()) instanceof JavaSdk) {
            return ((JavaSdk)type).getVersion(sdk);
        }
        return null;
    }
}

