/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration.framework;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinTestFramework;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinTestFrameworkUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0012\u0010\n\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinTestFramework;", "Lorg/jetbrains/kotlin/idea/testIntegration/framework/KotlinTestFramework;", "()V", "disabledTestAnnotation", "", "getDisabledTestAnnotation", "()Ljava/lang/String;", "isSlow", "", "()Z", "markerClassFqn", "getMarkerClassFqn", "frameworkMarkerClassExists", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isIgnoredMethod", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isTestClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isTestMethod", "qualifiedName", "responsibleFor", "kotlin.idea"})
public abstract class AbstractKotlinTestFramework
implements KotlinTestFramework {
    private final boolean isSlow;

    @NotNull
    public abstract String getMarkerClassFqn();

    @NotNull
    public abstract String getDisabledTestAnnotation();

    @Override
    public boolean isSlow() {
        return this.isSlow;
    }

    @Override
    public boolean responsibleFor(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this.frameworkMarkerClassExists(declaration2)) {
            return false;
        }
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            return this.isTestClass((KtClassOrObject)declaration2);
        }
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
            if (ktClassOrObject == null) {
                return false;
            }
            KtClassOrObject containingClass2 = ktClassOrObject;
            if (!this.isTestClass(containingClass2)) {
                return false;
            }
            return this.isTestMethod((KtNamedFunction)declaration2);
        }
        return false;
    }

    private final boolean frameworkMarkerClassExists(KtNamedDeclaration declaration2) {
        return KotlinTestFrameworkUtils.INSTANCE.hasClass(this.getMarkerClassFqn(), declaration2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTestClass(@NotNull KtClassOrObject declaration2) {
        KtNamedFunction it;
        void $this$none$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtClassOrObject $this$with = declaration2;
        boolean bl = false;
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$with))) return false;
        if ($this$with.isAnnotation()) return false;
        if (!$this$with.getAnnotationEntries().isEmpty()) return true;
        Iterable $this$filterIsInstance$iv = $this$with.getSuperTypeListEntries();
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtSuperTypeCallEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!((List)destination$iv$iv).isEmpty()) return true;
        $this$filterIsInstance$iv = $this$with.getDeclarations();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return false;
        }
        object = $this$none$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            it = (KtNamedFunction)element$iv;
            boolean bl2 = false;
        } while (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it)));
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTestMethod(@NotNull KtNamedFunction function2) {
        void $this$getStrictParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        KtNamedFunction $this$with = function2;
        boolean bl = false;
        if ($this$with.isTopLevel()) return false;
        if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)$this$with))) return false;
        if (KotlinRefactoringUtilKt.isAbstract((KtNamedDeclaration)$this$with)) return false;
        if ($this$with.isLocal()) return false;
        if (KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)$this$with))) return false;
        PsiElement psiElement2 = (PsiElement)$this$with;
        boolean $i$f$getStrictParentOfType = false;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)true);
        if (ktObjectDeclaration == null) return true;
        if (!ktObjectDeclaration.isObjectLiteral()) return true;
        return false;
    }

    @Override
    public boolean isIgnoredMethod(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return KotlinTestFrameworkUtils.INSTANCE.isAnnotated((KtAnnotated)function2, "kotlin.test.Ignore") || KotlinTestFrameworkUtils.INSTANCE.isAnnotated((KtAnnotated)function2, this.getDisabledTestAnnotation());
    }

    @Override
    @Nullable
    public String qualifiedName(@NotNull KtNamedDeclaration declaration2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            FqName fqName2 = ((KtClassOrObject)declaration2).getFqName();
            string = fqName2 != null ? fqName2.asString() : null;
        } else {
            KtClassOrObject ktClassOrObject;
            string = ktNamedDeclaration instanceof KtNamedFunction ? ((ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null) : null;
        }
        return string;
    }
}

