/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TypeOfAnnotationMemberFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "typeReference", "fixedType", "", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class TypeOfAnnotationMemberFix
extends KotlinQuickFixAction<KtTypeReference>
implements CleanupFix {
    private final String fixedType;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("replace.array.of.boxed.with.array.of.primitive", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtTypeReference ktTypeReference = (KtTypeReference)this.getElement();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference psiElement2 = ktTypeReference;
        psiElement2.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)psiElement2), (boolean)false, (int)2, null).createType(this.fixedType));
    }

    public TypeOfAnnotationMemberFix(@NotNull KtTypeReference typeReference2, @NotNull String fixedType) {
        Intrinsics.checkNotNullParameter((Object)typeReference2, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)fixedType, (String)"fixedType");
        super((PsiElement)typeReference2);
        this.fixedType = fixedType;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\bH\u0002J\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TypeOfAnnotationMemberFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getArrayItemType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isItemTypeToFix", "", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtTypeReference)) {
                psiElement2 = null;
            }
            KtTypeReference ktTypeReference = (KtTypeReference)psiElement2;
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference typeReference2 = ktTypeReference;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)typeReference2, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference2);
            if (kotlinType == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeReference.analyze(Bo\u2026Reference] ?: return null");
            KotlinType type2 = kotlinType;
            KotlinType kotlinType2 = this.getArrayItemType(type2);
            if (kotlinType2 == null) {
                return null;
            }
            KotlinType itemType = kotlinType2;
            Object object = itemType.getConstructor().getDeclarationDescriptor();
            if (object == null || (object = object.getName()) == null || (object = object.asString()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"itemType.constructor.dec\u2026asString() ?: return null");
            Object itemTypeName = object;
            if (!this.isItemTypeToFix(itemType)) {
                return null;
            }
            String fixedArrayTypeText = (String)itemTypeName + "Array";
            return new TypeOfAnnotationMemberFix(typeReference2, fixedArrayTypeText);
        }

        private final KotlinType getArrayItemType(KotlinType $this$getArrayItemType) {
            if (!KotlinBuiltIns.isArray((KotlinType)$this$getArrayItemType)) {
                return null;
            }
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)$this$getArrayItemType.getArguments());
            if (typeProjection == null) {
                return null;
            }
            TypeProjection boxedType = typeProjection;
            if (boxedType.isStarProjection()) {
                return null;
            }
            return boxedType.getType();
        }

        private final boolean isItemTypeToFix(KotlinType $this$isItemTypeToFix) {
            return KotlinBuiltIns.isByte((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isChar((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isShort((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isInt((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isLong((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isFloat((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isDouble((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isBoolean((KotlinType)$this$isItemTypeToFix);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

