/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomExecutions;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomGoals;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.extensions.gradle.RepositoryDescription;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeGeneralLanguageFeatureSupportFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 H2\u00020\u0001:\u0001HB)\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J,\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001f\u001a\u00020\u0003H\u0002J(\u0010 \u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-H\u0016J(\u0010.\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J(\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0014J8\u00104\u001a\u00020\r2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u0005H\u0004J \u0010:\u001a\u00020\r2\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010;\u001a\u00020\u0003H\u0014J\u0010\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H$J\u0010\u0010@\u001a\u00020\u00052\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010A\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010B\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0003H$J4\u0010C\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010D\u001a\u0004\u0018\u00010\u00032\b\u0010E\u001a\u0004\u0018\u00010\u00032\u0006\u0010F\u001a\u00020G2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "testArtifactId", "", "addJunit", "", "name", "presentableText", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPresentableText", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "changeMavenFeatureConfiguration", "messageTitle", "changePomFile", "file", "Lcom/intellij/psi/PsiFile;", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "checkKotlinPlugin", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureModule", "configurePlugin", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "createExecution", "pomFile", "kotlinPlugin", "executionId", "goalName", "isTest", "createExecutions", "getMinimumSupportedVersion", "getStatus", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getStdlibArtifactId", "hasKotlinPlugin", "isKotlinModule", "isRelevantGoal", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "Companion", "kotlin.maven"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    private final String testArtifactId;
    private final boolean addJunit;
    @NotNull
    private final String name;
    @NotNull
    private final String presentableText;
    @NotNull
    public static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    public static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module2 = moduleSourceRootGroup.getBaseModule();
        if (BuildSystemTypeKt.getBuildSystemType(module2) != BuildSystemType.Maven) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        PsiFile psi2 = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiFile>(module2){
            final /* synthetic */ Module $module;

            @Nullable
            public final PsiFile invoke() {
                return KotlinMavenConfigurator.Companion.findModulePomFile(this.$module);
            }
            {
                this.$module = module2;
                super(0);
            }
        });
        if (psi2 == null || !psi2.isValid() || !(psi2 instanceof XmlFile) || ((XmlFile)psi2).getVirtualFile() == null) {
            return ConfigureKotlinStatus.BROKEN;
        }
        if (this.isKotlinModule(module2)) {
            return (ConfigureKotlinStatus)((Object)ApplicationUtilsKt.runReadAction((Function0)new Function0<ConfigureKotlinStatus>(this, module2){
                final /* synthetic */ KotlinMavenConfigurator this$0;
                final /* synthetic */ Module $module;

                @NotNull
                public final ConfigureKotlinStatus invoke() {
                    return KotlinMavenConfigurator.access$checkKotlinPlugin(this.this$0, this.$module);
                }
                {
                    this.this$0 = kotlinMavenConfigurator;
                    this.$module = module2;
                    super(0);
                }
            }));
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigureKotlinStatus checkKotlinPlugin(Module module2) {
        boolean bl;
        block16: {
            Object v6;
            MavenPlugin it;
            block14: {
                Iterable iterable;
                PsiFile psiFile2 = Companion.findModulePomFile(module2);
                if (!(psiFile2 instanceof XmlFile)) {
                    psiFile2 = null;
                }
                XmlFile xmlFile = (XmlFile)psiFile2;
                if (xmlFile == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                XmlFile psi2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
                if (pomFile == null) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                PomFile pom2 = pomFile;
                if (this.hasKotlinPlugin(pom2)) {
                    return ConfigureKotlinStatus.CONFIGURED;
                }
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
                MavenProject mavenProject = mavenProjectsManager.findProject(module2);
                if (mavenProject == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"mavenProjectsManager.fin\u2026figureKotlinStatus.BROKEN");
                MavenProject mavenProject2 = mavenProject;
                MavenId kotlinPluginId = PomFileKt.kotlinPluginId(null);
                List list2 = mavenProject2.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"mavenProject.plugins");
                Iterable iterable2 = iterable = (Iterable)list2;
                for (Object t : iterable2) {
                    it = (MavenPlugin)t;
                    boolean bl2 = false;
                    MavenPlugin mavenPlugin = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenPlugin, (String)"it");
                    if (!mavenPlugin.getMavenId().equals(kotlinPluginId.getGroupId(), kotlinPluginId.getArtifactId())) continue;
                    v6 = t;
                    break block14;
                }
                v6 = null;
            }
            MavenPlugin mavenPlugin = v6;
            if (mavenPlugin == null) {
                return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
            }
            MavenPlugin kotlinPlugin = mavenPlugin;
            List list3 = kotlinPlugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"kotlinPlugin.executions");
            Iterable $this$any$iv = list3;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block15: {
                        void $this$any$iv2;
                        it = (MavenPlugin.Execution)element$iv;
                        boolean bl4 = false;
                        MavenPlugin mavenPlugin2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)mavenPlugin2, (String)"it");
                        List list4 = mavenPlugin2.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"it.goals");
                        Iterable iterable = list4;
                        KotlinMavenConfigurator kotlinMavenConfigurator = this;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String p1 = (String)element$iv2;
                                boolean bl5 = false;
                                if (!kotlinMavenConfigurator.isRelevantGoal(p1)) continue;
                                bl3 = true;
                                break block15;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final boolean hasKotlinPlugin(PomFile pom2) {
        boolean bl;
        block9: {
            MavenDomPlugin mavenDomPlugin = pom2.findPlugin(PomFileKt.kotlinPluginId(null));
            if (mavenDomPlugin == null) {
                return false;
            }
            MavenDomPlugin plugin = mavenDomPlugin;
            MavenDomExecutions mavenDomExecutions = plugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomExecutions, (String)"plugin.executions");
            List list2 = mavenDomExecutions.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"plugin.executions.executions");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        MavenDomPluginExecution it = (MavenDomPluginExecution)element$iv;
                        boolean bl3 = false;
                        MavenDomPluginExecution mavenDomPluginExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomPluginExecution, (String)"it");
                        MavenDomGoals mavenDomGoals = mavenDomPluginExecution.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomGoals, (String)"it.goals");
                        List list3 = mavenDomGoals.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it.goals.goals");
                        Iterable $this$any$iv2 = list3;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                MavenDomGoal it2 = (MavenDomGoal)element$iv2;
                                boolean bl4 = false;
                                MavenDomGoal mavenDomGoal = it2;
                                Intrinsics.checkNotNullExpressionValue((Object)mavenDomGoal, (String)"it");
                                String string = mavenDomGoal.getStringValue();
                                if (string == null) {
                                    string = "";
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.stringValue ?: \"\"");
                                if (!this.isRelevantGoal(string)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void configure(@NotNull Project project2, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project2, this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, (Runnable)new Runnable(this, project2, dialog2){
            final /* synthetic */ KotlinMavenConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureDialogWithModulesAndVersion $dialog;

            public final void run() {
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                List<Module> list2 = this.$dialog.getModulesToConfigure();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"dialog.modulesToConfigure");
                for (Module module2 : MavenModulesRelationshipKt.excludeMavenChildrenModules(this.$project, list2)) {
                    PsiFile file2 = KotlinMavenConfigurator.Companion.findModulePomFile(module2);
                    if (file2 != null && org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$canConfigureFile(KotlinMavenConfigurator.Companion, file2)) {
                        String string = this.$dialog.getKotlinVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dialog.kotlinVersion");
                        this.this$0.configureModule(module2, file2, IdeKotlinVersion.Companion.get(string), collector2);
                        OpenFileAction.openFile((VirtualFile)file2.getVirtualFile(), (Project)this.$project);
                        continue;
                    }
                    Object[] objectArray = new Object[1];
                    String string = module2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
                    objectArray[0] = string;
                    org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$showErrorMessage(KotlinMavenConfigurator.Companion, this.$project, KotlinMavenBundle.message("error.cant.find.pom.for.module", objectArray));
                }
                collector2.showNotification();
            }
            {
                this.this$0 = kotlinMavenConfigurator;
                this.$project = project2;
                this.$dialog = configureDialogWithModulesAndVersion;
            }
        });
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    @NotNull
    protected abstract String getStdlibArtifactId(@NotNull Module var1, @NotNull IdeKotlinVersion var2);

    public boolean configureModule(@NotNull Module module2, @NotNull PsiFile file2, @NotNull IdeKotlinVersion version2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        return this.changePomFile(module2, file2, version2, collector2);
    }

    private final boolean changePomFile(Module module2, PsiFile file2, IdeKotlinVersion version2, NotificationMessageCollector collector2) {
        RepositoryDescription repositoryDescription;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            String string = "Virtual file should exists for psi file " + file2.getName();
            throw new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile3 = virtualFile2;
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module2.getProject(), (VirtualFile)virtualFile3);
        if (domModel == null) {
            Project project2 = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
            KotlinMavenConfigurator.Companion.showErrorMessage(project2, null);
            return false;
        }
        PsiFile psiFile2 = file2;
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)psiFile2);
        if (pomFile == null) {
            return false;
        }
        PomFile pom2 = pomFile;
        pom2.addProperty(KOTLIN_VERSION_PROPERTY, version2.getArtifactVersion());
        pom2.addDependency(new MavenId(GROUP_ID, this.getStdlibArtifactId(module2, version2), "${kotlin.version}"), MavenArtifactScope.COMPILE, null, false, null);
        if (this.testArtifactId != null) {
            pom2.addDependency(new MavenId(GROUP_ID, this.testArtifactId, "${kotlin.version}"), MavenArtifactScope.TEST, null, false, null);
        }
        if (this.addJunit) {
            pom2.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
        }
        if ((repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version2)) != null) {
            pom2.addLibraryRepository(repositoryDescription);
            pom2.addPluginRepository(repositoryDescription);
        }
        MavenDomPlugin plugin = pom2.addPlugin(new MavenId(GROUP_ID, MAVEN_PLUGIN_ID, "${kotlin.version}"));
        this.createExecutions(pom2, plugin, module2);
        this.configurePlugin(pom2, plugin, module2, version2);
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file2));
        Object[] objectArray = new Object[1];
        String string = virtualFile3.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.path");
        objectArray[0] = string;
        collector2.addMessage(KotlinMavenBundle.message("file.was.modified", objectArray));
        return true;
    }

    protected void configurePlugin(@NotNull PomFile pom2, @NotNull MavenDomPlugin plugin, @NotNull Module module2, @NotNull IdeKotlinVersion version2) {
        Intrinsics.checkNotNullParameter((Object)pom2, (String)"pom");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module2, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
        Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)goalName, (String)"goalName");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        pomFile.addKotlinExecution(module2, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
        if (KotlinMavenConfigurator.Companion.hasJavaFiles(module2)) {
            pomFile.addJavacExecutions(module2, kotlinPlugin);
        }
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module2, @Nullable String languageVersion2, @Nullable String apiVersion2, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        boolean runtimeUpdateRequired;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        var $fun$doUpdateMavenLanguageVersion$1 = new Function0<PsiElement>(module2, languageVersion2, apiVersion2){
            final /* synthetic */ Module $module;
            final /* synthetic */ String $languageVersion;
            final /* synthetic */ String $apiVersion;

            @Nullable
            public final PsiElement invoke() {
                PsiFile psiFile2 = KotlinMavenConfigurator.Companion.findModulePomFile(this.$module);
                if (!(psiFile2 instanceof XmlFile)) {
                    psiFile2 = null;
                }
                XmlFile xmlFile = (XmlFile)psiFile2;
                if (xmlFile == null) {
                    return null;
                }
                XmlFile psi2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
                if (pomFile == null) {
                    return null;
                }
                PomFile pom2 = pomFile;
                return PomFileKt.changeLanguageVersion(pom2, this.$languageVersion, this.$apiVersion);
            }
            {
                this.$module = module2;
                this.$languageVersion = string;
                this.$apiVersion = string2;
                super(0);
            }
        };
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2);
        if (ideKotlinVersion != null && (ideKotlinVersion = ideKotlinVersion.getApiVersion()) != null) {
            IdeKotlinVersion ideKotlinVersion2;
            IdeKotlinVersion runtimeVersion = ideKotlinVersion2 = ideKotlinVersion;
            boolean bl2 = false;
            bl = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else {
            bl = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature", requiredStdlibVersion), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
            return;
        }
        PsiElement element3 = $fun$doUpdateMavenLanguageVersion$1.invoke();
        if (element3 == null) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
        } else {
            Project project2 = module2.getProject();
            PsiFile psiFile2 = element3.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project2, virtualFile2, textRange.getStartOffset()).navigate(true);
        }
    }

    @Override
    public void addLibraryDependency(@NotNull Module module2, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library2, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull DependencyScope scope2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module2, (PsiElement)element3);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"OrderEntryFix.suggestSco\u2026Location(module, element)");
        DependencyScope scope3 = dependencyScope;
        JavaProjectModelModificationService.getInstance((Project)module2.getProject()).addDependency(module2, library2, scope3);
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module2, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        String messageTitle = ChangeGeneralLanguageFeatureSupportFix.Companion.getFixText(feature, state);
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.getRuntimeLibraryVersionOrDefault(module2).getApiVersion().compareTo(sinceVersion) < 0) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature.support", feature.getPresentableName(), sinceVersion), (String)messageTitle);
            return;
        }
        PsiElement element3 = this.changeMavenFeatureConfiguration(module2, feature, state, messageTitle);
        if (element3 != null) {
            Project project2 = module2.getProject();
            PsiFile psiFile2 = element3.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project2, virtualFile2, textRange.getStartOffset()).navigate(true);
        }
    }

    private final PsiElement changeMavenFeatureConfiguration(Module module2, LanguageFeature feature, LanguageFeature.State state, @NlsContexts.DialogTitle String messageTitle) {
        PsiFile psiFile2 = Companion.findModulePomFile(module2);
        if (!(psiFile2 instanceof XmlFile)) {
            psiFile2 = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile2;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi2 = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi2);
        if (pomFile == null) {
            return null;
        }
        PomFile pom2 = pomFile;
        PsiElement element3 = PomFileKt.changeFeatureConfiguration(pom2, feature, state);
        if (element3 == null) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)messageTitle);
        }
        return element3;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    protected KotlinMavenConfigurator(@Nullable String testArtifactId, boolean addJunit, @NotNull String name2, @NotNull String presentableText) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)presentableText, (String)"presentableText");
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name2;
        this.presentableText = presentableText;
    }

    public static final /* synthetic */ ConfigureKotlinStatus access$checkKotlinPlugin(KotlinMavenConfigurator $this, Module module2) {
        return $this.checkKotlinPlugin(module2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "()V", "GROUP_ID", "", "KOTLIN_VERSION_PROPERTY", "MAVEN_PLUGIN_ID", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "findModulePomFile", "module", "Lcom/intellij/openapi/module/Module;", "hasJavaFiles", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "kotlin.maven"})
    public static final class Companion {
        private final boolean hasJavaFiles(Module module2) {
            return !FileTypeIndex.getFiles((FileType)((FileType)JavaFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module2)).isEmpty();
        }

        @Nullable
        public final PsiFile findModulePomFile(@NotNull Module module2) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(module.project)");
            List list2 = mavenProjectsManager.getProjectsFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"MavenProjectsManager.get\u2026le.project).projectsFiles");
            List files2 = list2;
            for (VirtualFile file2 : files2) {
                PsiFile psiFile2;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)module2.getProject());
                if (Intrinsics.areEqual((Object)module2, (Object)fileModule) ^ true) continue;
                if (PsiManager.getInstance((Project)module2.getProject()).findFile(file2) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"PsiManager.getInstance(m\u2026indFile(file) ?: continue");
                if (!MavenDomUtil.isProjectFile((PsiFile)psiFile2)) continue;
                return psiFile2;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
        }

        private final void showErrorMessage(Project project2, @NlsContexts.DialogMessage String message2) {
            String cantConfigureAutomatically = KotlinMavenBundle.message("error.cant.configure.maven.automatically", new Object[0]);
            String seeInstructions = KotlinMavenBundle.message("error.see.installation.instructions", new Object[0]);
            Messages.showErrorDialog((Project)project2, (String)("<html>" + cantConfigureAutomatically + "<br/>" + (String)(message2 != null ? message2 + "</br>" : "") + seeInstructions + "</html>"), (String)KotlinMavenBundle.message("configure.title", new Object[0]));
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$canConfigureFile(Companion $this, PsiFile file2) {
            return $this.canConfigureFile(file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

