/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.surroundWith;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.debugger.surroundWith.KotlinRuntimeTypeCastSurrounder;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder;", "Lorg/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder;", "()V", "getTemplateDescription", "", "isApplicable", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "surroundExpression", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "SurroundWithCastWorker", "kotlin.jvm-debugger.evaluation"})
public final class KotlinRuntimeTypeCastSurrounder
extends KotlinExpressionSurrounder {
    @Override
    protected boolean isApplicable(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!super.isApplicable(expression2)) {
            return false;
        }
        if (!expression2.isPhysical()) {
            return false;
        }
        PsiFile file2 = expression2.getContainingFile();
        if (!(file2 instanceof KtCodeFragment)) {
            return false;
        }
        KotlinType kotlinType = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (kotlinType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expression.analyze(BodyR\u2026pression) ?: return false");
        KotlinType type2 = kotlinType;
        return TypeUtils.canHaveSubtypes((KotlinTypeChecker)KotlinTypeChecker.DEFAULT, (KotlinType)type2);
    }

    @Override
    @Nullable
    protected TextRange surroundExpression(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtExpression expression2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
            DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
            DebuggerContextImpl debuggerContext = debuggerContextImpl;
            DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
            if (debuggerSession == null) break block1;
            ProgressWindow progressWindow = new ProgressWindow(true, expression2.getProject());
            SurroundWithCastWorker worker2 = new SurroundWithCastWorker(editor2, expression2, debuggerContext, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(JavaDebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
            if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                debugProcessImpl.startProgress((DebuggerCommandImpl)worker2, progressWindow);
            }
        }
        return null;
    }

    @NotNull
    public String getTemplateDescription() {
        return KotlinDebuggerEvaluationBundle.message("surround.with.runtime.type.cast.template", new Object[0]);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder$SurroundWithCastWorker;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluator;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "typeCalculationFinished", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.jvm-debugger.evaluation"})
    private final class SurroundWithCastWorker
    extends KotlinRuntimeTypeEvaluator {
        private final Editor myEditor;

        @Override
        protected void typeCalculationFinished(@Nullable KotlinType type2) {
            if (type2 == null) {
                return;
            }
            this.hold();
            Project project2 = this.myEditor.getProject();
            Runnable runnable = new Runnable(this, project2, type2){
                final /* synthetic */ SurroundWithCastWorker this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ KotlinType $type;

                public final void run() {
                    WriteCommandAction.writeCommandAction((Project)this.$project).withName(JavaDebuggerBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0])).run(new ThrowableRunnable(this){
                        final /* synthetic */ typeCalculationFinished.1 this$0;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            try {
                                PsiElement psiElement2 = SurroundWithCastWorker.access$getMyElement$p(this.this$0.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myElement");
                                Project project2 = psiElement2.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myElement.project");
                                KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
                                ClassifierDescriptor classifierDescriptor = this.this$0.$type.getConstructor().getDeclarationDescriptor();
                                Intrinsics.checkNotNull((Object)classifierDescriptor);
                                FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
                                Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"DescriptorUtils.getFqNam\u2026.declarationDescriptor!!)");
                                FqNameUnsafe fqName2 = fqNameUnsafe;
                                KtExpression ktExpression = factory2.createExpression("(expr as " + fqName2.asString() + ")");
                                if (ktExpression == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                }
                                KtParenthesizedExpression parentCast = (KtParenthesizedExpression)ktExpression;
                                KtExpression ktExpression2 = parentCast.getExpression();
                                if (ktExpression2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS");
                                }
                                KtBinaryExpressionWithTypeRHS cast = (KtBinaryExpressionWithTypeRHS)ktExpression2;
                                cast.getLeft().replace(SurroundWithCastWorker.access$getMyElement$p(this.this$0.this$0));
                                PsiElement psiElement3 = SurroundWithCastWorker.access$getMyElement$p(this.this$0.this$0).replace((PsiElement)parentCast);
                                if (psiElement3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                }
                                KtExpression expr = (KtExpression)psiElement3;
                                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)expr, null, 2, null);
                                TextRange range2 = expr.getTextRange();
                                SelectionModel selectionModel = SurroundWithCastWorker.access$getMyEditor$p(this.this$0.this$0).getSelectionModel();
                                TextRange textRange = range2;
                                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                                selectionModel.setSelection(textRange.getStartOffset(), range2.getEndOffset());
                                SurroundWithCastWorker.access$getMyEditor$p(this.this$0.this$0).getCaretModel().moveToOffset(range2.getEndOffset());
                                SurroundWithCastWorker.access$getMyEditor$p(this.this$0.this$0).getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            }
                            finally {
                                this.this$0.this$0.release();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = surroundWithCastWorker;
                    this.$project = project2;
                    this.$type = kotlinType;
                }
            };
            ProgressIndicator progressIndicator = this.myProgressIndicator;
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"myProgressIndicator");
            DebuggerInvocationUtil.invokeLater((Project)project2, (Runnable)runnable, (ModalityState)progressIndicator.getModalityState());
        }

        public SurroundWithCastWorker(@NotNull Editor myEditor, @NotNull KtExpression expression2, @NotNull DebuggerContextImpl context2, ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(myEditor, expression2, context2, indicator);
            this.myEditor = myEditor;
        }

        public static final /* synthetic */ PsiElement access$getMyElement$p(SurroundWithCastWorker $this) {
            return $this.myElement;
        }

        public static final /* synthetic */ Editor access$getMyEditor$p(SurroundWithCastWorker $this) {
            return $this.myEditor;
        }
    }
}

