/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.filter;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.filter.LocationToken;
import org.jetbrains.kotlin.idea.debugger.stepping.filter.StepOverCallerInfo;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/KotlinStepOverFilter;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;", "project", "Lcom/intellij/openapi/project/Project;", "tokensToSkip", "", "Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/LocationToken;", "callerInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/StepOverCallerInfo;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/StepOverCallerInfo;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCallingExpressionLines", "Lcom/intellij/util/Range;", "", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "kotlin.jvm-debugger.core"})
public final class KotlinStepOverFilter
implements KotlinMethodFilter {
    @NotNull
    private final Project project;
    private final Set<LocationToken> tokensToSkip;
    private final StepOverCallerInfo callerInfo;

    @Override
    public boolean locationMatches(@NotNull SuspendContextImpl context2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        if (DebuggerUtils.INSTANCE.isKotlinFakeLineNumber(location2)) {
            return false;
        }
        Object object = context2.getFrameProxy();
        if (object == null || (object = object.getStackFrame()) == null) {
            return true;
        }
        Object stackFrame = object;
        LocationToken token = LocationToken.Companion.from((StackFrame)stackFrame);
        StepOverCallerInfo callerInfo = StepOverCallerInfo.Companion.from(location2);
        if (callerInfo.getMethodName() != null && callerInfo.getMethodSignature() != null && Intrinsics.areEqual((Object)this.callerInfo, (Object)callerInfo)) {
            return token.getLineNumber() >= 0 && !this.tokensToSkip.contains(token);
        }
        return true;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        throw (Throwable)new IllegalStateException("Should not be called from Kotlin hint");
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinStepOverFilter(@NotNull Project project2, @NotNull Set<LocationToken> tokensToSkip, @NotNull StepOverCallerInfo callerInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(tokensToSkip, (String)"tokensToSkip");
        Intrinsics.checkNotNullParameter((Object)callerInfo, (String)"callerInfo");
        this.project = project2;
        this.tokensToSkip = tokensToSkip;
        this.callerInfo = callerInfo;
    }
}

