/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.dsl;

import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.Lambda;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000f\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/dsl/KotlinLambda;", "Lcom/intellij/debugger/streams/trace/dsl/Lambda;", "variableName", "", "body", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "(Ljava/lang/String;Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;)V", "getBody", "()Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "getVariableName", "()Ljava/lang/String;", "call", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "callName", "args", "", "(Ljava/lang/String;[Lcom/intellij/debugger/streams/trace/dsl/Expression;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "toCode", "indent", "", "kotlin.jvm-debugger.sequence"})
public final class KotlinLambda
implements Lambda {
    @NotNull
    private final String variableName;
    @NotNull
    private final CodeBlock body;

    @NotNull
    public Expression call(@NotNull String callName, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new TextExpression("(" + Convertable.DefaultImpls.toCode$default((Convertable)this, (int)0, (int)1, null) + ")").call(callName, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public String toCode(int indent) {
        return this.withIndent("{ " + this.getVariableName() + " ->\n", indent) + this.getBody().toCode(indent + 1) + "}";
    }

    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    @NotNull
    public CodeBlock getBody() {
        return this.body;
    }

    public KotlinLambda(@NotNull String variableName, @NotNull CodeBlock body2) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.variableName = variableName;
        this.body = body2;
    }

    @NotNull
    public Expression property(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return Lambda.DefaultImpls.property((Lambda)this, (String)propertyName);
    }

    @NotNull
    public String withIndent(@NotNull String $this$withIndent, int indent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        return Lambda.DefaultImpls.withIndent((Lambda)this, (String)$this$withIndent, (int)indent);
    }
}

