/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.kotlin.commonNative.KonanInstaller;
import com.jetbrains.kotlin.commonNative.debugger.KonanRemoteDebugProcess;
import com.jetbrains.kotlin.commonNative.runconfig.AttachmentStrategy;
import com.jetbrains.kotlin.commonNative.runconfig.BinaryRunConfiguration;
import com.jetbrains.kotlin.commonNative.runconfig.BinaryRunConfigurationType;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/mpp/debugger/MPPLocalAttachDebugger;", "Lcom/jetbrains/cidr/execution/debugger/CidrLocalAttachDebugger;", "lldbConfiguration", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration;)V", "doCreateDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "kotlin-ultimate.ultimate-native"})
public final class MPPLocalAttachDebugger
extends CidrLocalAttachDebugger {
    @NotNull
    protected CidrDebugProcess doCreateDebugProcess(@NotNull XDebugSession session, @NotNull ProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Project project2 = session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"session.project");
        RunManager runManager = RunManager.Companion.getInstance(project2);
        String string = processInfo.getExecutableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processInfo.executableName");
        RunnerAndConfigurationSettings settings2 = runManager.createConfiguration(string, BinaryRunConfigurationType.Companion.getInstance().getFactory());
        RunConfiguration runConfiguration = settings2.getConfiguration();
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.kotlin.commonNative.runconfig.BinaryRunConfiguration");
        }
        BinaryRunConfiguration runConfig = (BinaryRunConfiguration)runConfiguration;
        runConfig.setAttachmentStrategy(new AttachmentStrategy.ByPid(processInfo.getPid()));
        runConfig.setExecutable(new File((String)processInfo.getExecutableCannonicalPath().get()));
        KonanInstaller installer = new KonanInstaller(runConfig);
        DebuggerDriverConfiguration debuggerDriverConfiguration = this.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerDriverConfiguration, (String)"configuration");
        TrivialRunParameters runParams = new TrivialRunParameters(debuggerDriverConfiguration, (Installer)installer, null, 4, null);
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.executionScope((Project)session.getProject(), (RunProfile)((RunProfile)settings2.getConfiguration()));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScopes.execu\u2026, settings.configuration)");
        GlobalSearchScope searchScope2 = globalSearchScope;
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(session.getProject(), searchScope2);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026ion.project, searchScope)");
        TextConsoleBuilder consoleBuilder = textConsoleBuilder;
        RunParameters runParameters = (RunParameters)runParams;
        File file2 = runConfig.getExecutable();
        Intrinsics.checkNotNull((Object)file2);
        AttachmentStrategy attachmentStrategy = runConfig.getAttachmentStrategy();
        Intrinsics.checkNotNull((Object)attachmentStrategy);
        return (CidrDebugProcess)new KonanRemoteDebugProcess(runParameters, session, consoleBuilder, file2, attachmentStrategy);
    }

    public MPPLocalAttachDebugger(@NotNull DebuggerDriverConfiguration lldbConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lldbConfiguration, (String)"lldbConfiguration");
        super(lldbConfiguration);
    }
}

