/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.kotlin.commonNative.debugger.KonanStackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\u0010\u001a\u00020\t*\u00020\u0007H\u0002J\f\u0010\u0011\u001a\u00020\t*\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanExecutionStack;", "Lcom/jetbrains/cidr/execution/debugger/CidrExecutionStack;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "current", "", "suspensionCause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;ZLcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;)V", "newFrame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "Lorg/jetbrains/annotations/NotNull;", "isDisasm", "isKonan", "kotlin-ultimate.common-native"})
public final class KonanExecutionStack
extends CidrExecutionStack {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKonan(LLFrame $this$isKonan) {
        if ($this$isKonan.getLanguage() != DebuggerDriver.StandardDebuggerLanguage.C) return false;
        String string = $this$isKonan.getFile();
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isDisasm(LLFrame $this$isDisasm) {
        return $this$isDisasm.getFile() == null;
    }

    @NotNull
    protected CidrStackFrame newFrame(@NotNull LLFrame frame) {
        CidrStackFrame cidrStackFrame;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (this.isKonan(frame) || this.isDisasm(frame)) {
            LLThread lLThread = this.myThread;
            Intrinsics.checkNotNullExpressionValue((Object)lLThread, (String)"myThread");
            CidrDebugProcess cidrDebugProcess = this.myProcess;
            Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
            cidrStackFrame = new KonanStackFrame(lLThread, frame, this.mySuspensionCause, cidrDebugProcess);
        } else {
            cidrStackFrame = super.newFrame(frame);
        }
        Intrinsics.checkNotNullExpressionValue((Object)cidrStackFrame, (String)"when {\n    // disasm fra\u2026super.newFrame(frame)\n  }");
        return cidrStackFrame;
    }

    public KonanExecutionStack(@NotNull CidrDebugProcess process2, @NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause suspensionCause) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        super(process2, thread, frame, current, suspensionCause);
    }
}

