/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI;

import com.intellij.debugger.mockJDI.MockLocalVariable;
import com.intellij.debugger.mockJDI.MockLocation;
import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.members.MockPsiLambda;
import com.intellij.debugger.mockJDI.members.MockPsiMethod;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.values.MockObjectReference;
import com.intellij.debugger.mockJDI.values.MockValue;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class MockStackFrame
extends MockMirror
implements StackFrame {
    private final PsiElement myContext;
    private final List<MockLocalVariable> myLocalVariables = new ArrayList<MockLocalVariable>();
    private MockObjectReference myThisValue = null;

    public MockStackFrame(MockVirtualMachine virtualMachine) {
        this(virtualMachine, null);
    }

    public MockStackFrame(MockVirtualMachine virtualMachine, PsiElement context) {
        super(virtualMachine);
        this.myContext = context;
    }

    public void addVariable(String name, MockValue value) {
        this.myLocalVariables.add(new MockLocalVariable(this.myVirtualMachine, name, (MockType)value.type(), value));
    }

    public void addVariable(MockLocalVariable var) {
        this.myLocalVariables.add(var);
    }

    public void setThisValue(MockObjectReference val) {
        this.myThisValue = val;
    }

    @Override
    public Location location() {
        if (this.myContext == null) {
            throw new IllegalStateException("Context is not specified");
        }
        return (Location)ReadAction.compute(() -> {
            int offset = this.myContext.getTextRange().getStartOffset();
            PsiFile file2 = this.myContext.getContainingFile();
            int lineNumber = StringUtil.offsetToLineNumber((CharSequence)file2.getText(), (int)offset);
            String name = file2.getName();
            PsiParameterListOwner psiMethod = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (psiMethod == null) {
                UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)this.myContext, UMethod.class);
                if (uMethod != null) {
                    psiMethod = uMethod.getJavaPsi();
                } else {
                    throw new IllegalStateException("Method/lambda not found");
                }
            }
            MockMirror method = psiMethod instanceof PsiMethod ? new MockPsiMethod(this.myVirtualMachine, (PsiMethod)psiMethod) : new MockPsiLambda(this.myVirtualMachine, (PsiLambdaExpression)psiMethod);
            return new MockLocation(lineNumber, 0L, (Method)((Object)method), name, name);
        });
    }

    @Override
    public ThreadReference thread() {
        throw new UnsupportedOperationException("Not implemented: \"thread\" in " + this.getClass().getName());
    }

    @Override
    public ObjectReference thisObject() {
        return this.myThisValue;
    }

    @Override
    public List<LocalVariable> visibleVariables() {
        return new ArrayList<LocalVariable>(this.myLocalVariables);
    }

    @Override
    public LocalVariable visibleVariableByName(String string) {
        for (MockLocalVariable localVariable : this.myLocalVariables) {
            if (!localVariable.name().equals(string)) continue;
            return localVariable;
        }
        return null;
    }

    @Override
    public Value getValue(LocalVariable localVariable) {
        return ((MockLocalVariable)localVariable).getValue();
    }

    @Override
    public Map<LocalVariable, Value> getValues(List<? extends LocalVariable> list) {
        HashMap<LocalVariable, Value> map = new HashMap<LocalVariable, Value>();
        for (LocalVariable localVariable : list) {
            map.put(localVariable, this.getValue(localVariable));
        }
        return map;
    }

    @Override
    public void setValue(LocalVariable localVariable, Value value) {
        throw new UnsupportedOperationException("Not implemented: \"setValue\" in " + this.getClass().getName());
    }

    @Override
    public List<Value> getArgumentValues() {
        throw new UnsupportedOperationException("Not implemented: \"getArgumentValues\" in " + this.getClass().getName());
    }
}

