/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.simplify;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.internal.simplify.ArrayAdapter;
import tech.units.indriya.internal.simplify.BitScanner;
import tech.units.indriya.internal.simplify.Simplifier;

final class SimplificationWorker {
    private final BiPredicate<AbstractConverter, AbstractConverter> simpleComposeTest;
    private final BinaryOperator<AbstractConverter> simpleComposeAction;
    private AbstractConverter[] arrayOfConverters;

    public SimplificationWorker(BiPredicate<AbstractConverter, AbstractConverter> simpleComposeTest, BinaryOperator<AbstractConverter> simpleComposeAction) {
        this.simpleComposeTest = simpleComposeTest;
        this.simpleComposeAction = simpleComposeAction;
    }

    public AbstractConverter simplify(List<? extends UnitConverter> conversionSteps) {
        this.arrayOfConverters = conversionSteps.toArray(new AbstractConverter[0]);
        SimplificationWorker.sortToNormalFormOrder(this.arrayOfConverters);
        while (this.trySimplify() > 0) {
            SimplificationWorker.sortToNormalFormOrder(this.arrayOfConverters);
        }
        return SimplificationWorker.sequenceToConverter(this.arrayOfConverters);
    }

    private int trySimplify() {
        ArrayAdapter<AbstractConverter> adapter = ArrayAdapter.of(this.arrayOfConverters);
        int simplificationCount = adapter.visitSequentialPairsAndSimplify((a2, b2) -> {
            if (a2.isIdentity()) {
                return b2;
            }
            if (b2.isIdentity()) {
                return a2;
            }
            return this.simpleComposeTest.test((AbstractConverter)a2, (AbstractConverter)b2) ? (AbstractConverter)this.simpleComposeAction.apply((AbstractConverter)a2, b2) : null;
        });
        if (simplificationCount > 0) {
            this.arrayOfConverters = adapter.removeNulls(simplificationCount);
        }
        return simplificationCount;
    }

    private static void sortToNormalFormOrder(AbstractConverter[] arrayOfConverters) {
        BitScanner bitScanner = BitScanner.of(arrayOfConverters, UnitConverter::isLinear);
        bitScanner.visitBitSequences((fromIndex, toIndex) -> Arrays.sort(arrayOfConverters, fromIndex, toIndex, (a2, b2) -> {
            if (a2.isIdentity()) {
                if (b2.isIdentity()) {
                    return Simplifier.isNormalFormOrderWhenIdentity(a2, b2) ? -1 : 1;
                }
                return -1;
            }
            if (b2.isIdentity()) {
                return 1;
            }
            return Simplifier.isNormalFormOrderWhenCommutative(a2, b2) ? -1 : 1;
        }));
    }

    private static AbstractConverter sequenceToConverter(AbstractConverter[] sequence) {
        if (sequence == null || sequence.length == 0) {
            return AbstractConverter.IDENTITY;
        }
        if (sequence.length == 1) {
            AbstractConverter singleton = sequence[0];
            return singleton;
        }
        AbstractConverter.Pair start = new AbstractConverter.Pair(sequence[0], sequence[1]);
        return Arrays.stream(sequence).skip(2L).reduce(start, (tree, next) -> new AbstractConverter.Pair((UnitConverter)tree, (UnitConverter)next));
    }
}

