/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.language.English;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;

public class EnglishHybridDisambiguator
extends AbstractDisambiguator {
    private final Disambiguator chunker = new MultiWordChunker("/en/multiwords.txt", true, true);
    private final Disambiguator disambiguator = new XmlRuleDisambiguator(new English(), true);

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence input2) throws IOException {
        return this.disambiguate(input2, null);
    }

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence input2, @Nullable JLanguageTool.CheckCancelledCallback checkCanceled) throws IOException {
        AnalyzedSentence analyzedSentence = this.chunker.disambiguate(input2, checkCanceled);
        AnalyzedTokenReadings[] aTokens = analyzedSentence.getTokens();
        String POSTag = "";
        String lemma = "";
        String nextPOSTag = "";
        AnalyzedToken analyzedToken = null;
        for (int i2 = 0; i2 < aTokens.length; ++i2) {
            AnalyzedToken newAnalyzedToken;
            if (aTokens[i2].isWhitespace()) continue;
            if (checkCanceled != null && checkCanceled.checkCancelled()) break;
            if (!nextPOSTag.isEmpty()) {
                newAnalyzedToken = new AnalyzedToken(aTokens[i2].getToken(), nextPOSTag, lemma);
                if (aTokens[i2].hasPosTagAndLemma("</" + POSTag + ">", lemma)) {
                    nextPOSTag = "";
                    lemma = "";
                }
                aTokens[i2] = new AnalyzedTokenReadings(aTokens[i2], Arrays.asList(newAnalyzedToken), "EN_HybridDisambiguator");
                aTokens[i2].ignoreSpelling();
                continue;
            }
            analyzedToken = this.getMultiWordAnalyzedToken(aTokens, i2);
            if (analyzedToken == null) continue;
            POSTag = analyzedToken.getPOSTag().substring(1, analyzedToken.getPOSTag().length() - 1);
            lemma = analyzedToken.getLemma();
            newAnalyzedToken = new AnalyzedToken(analyzedToken.getToken(), POSTag, lemma);
            aTokens[i2] = new AnalyzedTokenReadings(aTokens[i2], Arrays.asList(newAnalyzedToken), "EN_HybridDisambiguator");
            aTokens[i2].ignoreSpelling();
            nextPOSTag = POSTag;
        }
        return this.disambiguator.disambiguate(new AnalyzedSentence(aTokens), checkCanceled);
    }

    private AnalyzedToken getMultiWordAnalyzedToken(AnalyzedTokenReadings[] aTokens, Integer i2) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        for (AnalyzedToken reading : aTokens[i2]) {
            String POSTag = reading.getPOSTag();
            if (POSTag == null || !POSTag.startsWith("<") || !POSTag.endsWith(">") || POSTag.startsWith("</")) continue;
            l.add(reading);
        }
        if (l.size() > 0) {
            AnalyzedToken selectedAT = null;
            int maxDistance = 0;
            block1: for (AnalyzedToken at : l) {
                String tag = "</" + at.getPOSTag().substring(1);
                String lemma = at.getLemma();
                int distance = 1;
                while (i2 + distance < aTokens.length) {
                    if (aTokens[i2 + distance].hasPosTagAndLemma(tag, lemma)) {
                        if (distance <= maxDistance) continue block1;
                        distance = maxDistance;
                        selectedAT = at;
                        continue block1;
                    }
                    ++distance;
                }
            }
            return selectedAT;
        }
        return null;
    }
}

