/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import morfologik.fsa.ByteSequenceIterator;
import morfologik.fsa.CFSA;
import morfologik.fsa.CFSA2;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.fsa.StateVisitor;

public abstract class FSA
implements Iterable<ByteBuffer> {
    public abstract int getRootNode();

    public abstract int getFirstArc(int var1);

    public abstract int getNextArc(int var1);

    public abstract int getArc(int var1, byte var2);

    public abstract byte getArcLabel(int var1);

    public abstract boolean isArcFinal(int var1);

    public abstract boolean isArcTerminal(int var1);

    public abstract int getEndNode(int var1);

    public abstract Set<FSAFlags> getFlags();

    public int getArcCount(int node) {
        int count = 0;
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            ++count;
            arc = this.getNextArc(arc);
        }
        return count;
    }

    public int getRightLanguageCount(int node) {
        throw new UnsupportedOperationException("Automaton not compiled with " + (Object)((Object)FSAFlags.NUMBERS));
    }

    public Iterable<ByteBuffer> getSequences(final int node) {
        if (node == 0) {
            return Collections.emptyList();
        }
        return new Iterable<ByteBuffer>(){

            @Override
            public Iterator<ByteBuffer> iterator() {
                return new ByteSequenceIterator(FSA.this, node);
            }
        };
    }

    public final Iterable<ByteBuffer> getSequences() {
        return this.getSequences(this.getRootNode());
    }

    @Override
    public final Iterator<ByteBuffer> iterator() {
        return this.getSequences().iterator();
    }

    public <T extends StateVisitor> T visitAllStates(T v) {
        return this.visitInPostOrder(v);
    }

    public <T extends StateVisitor> T visitInPostOrder(T v) {
        return this.visitInPostOrder(v, this.getRootNode());
    }

    public <T extends StateVisitor> T visitInPostOrder(T v, int node) {
        this.visitInPostOrder(v, node, new BitSet());
        return v;
    }

    private boolean visitInPostOrder(StateVisitor v, int node, BitSet visited) {
        if (visited.get(node)) {
            return true;
        }
        visited.set(node);
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (!this.isArcTerminal(arc) && !this.visitInPostOrder(v, this.getEndNode(arc), visited)) {
                return false;
            }
            arc = this.getNextArc(arc);
        }
        return v.accept(node);
    }

    public <T extends StateVisitor> T visitInPreOrder(T v) {
        return this.visitInPreOrder(v, this.getRootNode());
    }

    public <T extends StateVisitor> T visitInPreOrder(T v, int node) {
        this.visitInPreOrder(v, node, new BitSet());
        return v;
    }

    protected static final byte[] readRemaining(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) >= 0) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }

    private void visitInPreOrder(StateVisitor v, int node, BitSet visited) {
        if (visited.get(node)) {
            return;
        }
        visited.set(node);
        if (v.accept(node)) {
            int arc = this.getFirstArc(node);
            while (arc != 0) {
                if (!this.isArcTerminal(arc)) {
                    this.visitInPreOrder(v, this.getEndNode(arc), visited);
                }
                arc = this.getNextArc(arc);
            }
        }
    }

    public static FSA read(InputStream stream) throws IOException {
        FSAHeader header2 = FSAHeader.read(stream);
        switch (header2.version) {
            case 5: {
                return new FSA5(stream);
            }
            case -59: {
                return new CFSA(stream);
            }
            case -58: {
                return new CFSA2(stream);
            }
        }
        throw new IOException(String.format(Locale.ROOT, "Unsupported automaton version: 0x%02x", header2.version & 0xFF));
    }

    public static <T extends FSA> T read(InputStream stream, Class<? extends T> clazz) throws IOException {
        FSA fsa = FSA.read(stream);
        if (!clazz.isInstance(fsa)) {
            throw new IOException(String.format(Locale.ROOT, "Expected FSA type %s, but read an incompatible type %s.", clazz.getName(), fsa.getClass().getName()));
        }
        return (T)((FSA)clazz.cast(fsa));
    }
}

