/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.ibm.icu.text.MessagePattern;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NlsCapitalizationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.I18nInspection;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public class TitleCapitalizationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                UExpression uElement = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UInjectionHost.class, UCallExpression.class, UReferenceExpression.class});
                if (uElement == null) {
                    return;
                }
                Value titleValue = TitleCapitalizationInspection.getTitleValue(uElement, new HashSet());
                if (titleValue == null) {
                    return;
                }
                List<UExpression> usages = I18nInspection.findIndirectUsages(uElement, false);
                if (usages.isEmpty()) {
                    usages = Collections.singletonList(uElement);
                }
                EnumSet<Nls.Capitalization> capitalizationContexts = EnumSet.noneOf(Nls.Capitalization.class);
                for (UExpression usage : usages) {
                    capitalizationContexts.add(this.getCapitalization(usage));
                }
                capitalizationContexts.remove(Nls.Capitalization.NotSpecified);
                for (Nls.Capitalization capitalization : capitalizationContexts) {
                    String message;
                    if (titleValue.isSatisfied(capitalization)) continue;
                    TitleCapitalizationFix fix = null;
                    if (capitalizationContexts.size() > 1) {
                        message = JavaI18nBundle.message("inspection.title.capitalization.mix.description", new Object[0]);
                    } else if (titleValue instanceof DeclaredValue) {
                        message = JavaI18nBundle.message("inspection.title.capitalization.mismatch.description", titleValue, TitleCapitalizationInspection.getCapitalizationName(capitalization));
                    } else {
                        fix = titleValue.canFix() && element instanceof PsiExpression ? new TitleCapitalizationFix(titleValue, capitalization) : null;
                        message = JavaI18nBundle.message("inspection.title.capitalization.description", titleValue, TitleCapitalizationInspection.getCapitalizationName(capitalization));
                    }
                    holder.registerProblem(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                }
            }

            private Nls.Capitalization getCapitalization(UExpression usage) {
                Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
                NlsInfo info = NlsInfo.forExpression(usage, false);
                if (info instanceof NlsInfo.Localized) {
                    capitalization = ((NlsInfo.Localized)info).getCapitalization();
                } else if (info.getNlsStatus() == ThreeState.UNSURE) {
                    PsiParameter parameter;
                    PsiMethod method;
                    UCallExpression call;
                    UElement parent = usage.getUastParent();
                    if (usage instanceof UCallExpression && parent instanceof UQualifiedReferenceExpression) {
                        parent = parent.getUastParent();
                    }
                    if ((call = (UCallExpression)ObjectUtils.tryCast((Object)parent, UCallExpression.class)) != null && (method = call.resolve()) != null && (parameter = AnnotationContext.getParameter((PsiMethod)method, (UCallExpression)call, (UExpression)usage)) != null) {
                        capitalization = TitleCapitalizationInspection.getSupplierCapitalization(parameter);
                    }
                }
                return capitalization;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$1", "visitElement"));
            }
        };
    }

    @Nls
    private static String getCapitalizationName(Nls.Capitalization capitalization) {
        switch (capitalization) {
            case Title: {
                return JavaI18nBundle.message("capitalization.kind.title", new Object[0]);
            }
            case Sentence: {
                return JavaI18nBundle.message("capitalization.kind.sentence", new Object[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    private static Value getTitleValue(@Nullable UExpression arg, Set<? super UExpression> processed) {
        if (arg instanceof UInjectionHost) {
            return Value.of((UInjectionHost)arg);
        }
        if (arg instanceof UCallExpression) {
            UCallExpression call = (UCallExpression)arg;
            UExpression returnValue = StringFlowUtil.getReturnValue((UCallExpression)call);
            if (arg.equals(returnValue)) {
                return null;
            }
            if (returnValue != null && processed.add((UExpression)returnValue)) {
                return TitleCapitalizationInspection.getTitleValue(returnValue, processed);
            }
            Value fromProperty = Value.of(TitleCapitalizationInspection.getPropertyArgument(call), call.getValueArgumentCount() > 1);
            if (fromProperty != null) {
                return fromProperty;
            }
        }
        if (arg instanceof UResolvable) {
            Value value;
            Value value2;
            PsiElement target = ((UResolvable)arg).resolve();
            if (target instanceof PsiModifierListOwner && (value2 = Value.of(NlsInfo.forModifierListOwner((PsiModifierListOwner)target))) != null) {
                return value2;
            }
            PsiType type = arg.getExpressionType();
            if (type != null && (value = Value.of(NlsInfo.forType(type))) != null) {
                return value;
            }
        }
        return null;
    }

    @Nullable
    private static Property getPropertyArgument(UCallExpression arg) {
        List args = arg.getValueArguments();
        if (!args.isEmpty()) {
            return JavaI18nUtil.resolveProperty((UExpression)args.get(0));
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Nls.Capitalization getSupplierCapitalization(PsiParameter parameter) {
        NlsInfo info;
        PsiType typeParameter;
        PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)parameter.getType(), PsiClassType.class);
        if (classType != null && classType.equalsToText("java.util.function.Supplier<java.lang.String>") && (typeParameter = (PsiType)ArrayUtil.getFirstElement((Object[])classType.getParameters())) != null && (info = NlsInfo.forType(typeParameter)) instanceof NlsInfo.Localized) {
            Nls.Capitalization capitalization = ((NlsInfo.Localized)info).getCapitalization();
            if (capitalization == null) {
                TitleCapitalizationInspection.$$$reportNull$$$0(1);
            }
            return capitalization;
        }
        Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
        if (capitalization == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(2);
        }
        return capitalization;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupplierCapitalization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PropertyValue
    implements Value {
        private final String myPresentation;
        private final MessagePattern myPattern;

        PropertyValue(String presentation, MessagePattern pattern) {
            this.myPresentation = presentation;
            this.myPattern = pattern;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myPresentation;
            if (string == null) {
                PropertyValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        private int getMessagesForPart(int index) {
            MessagePattern.Part part = this.myPattern.getPart(index);
            if (part.getType() != MessagePattern.Part.Type.ARG_START) {
                return 0;
            }
            int limitPart = this.myPattern.getLimitPartIndex(index);
            int msgCount = 0;
            int nesting = -1;
            for (int i = index + 1; i < limitPart; ++i) {
                part = this.myPattern.getPart(i);
                if (part.getType() != MessagePattern.Part.Type.MSG_START) continue;
                if (nesting == -1) {
                    nesting = part.getValue();
                } else if (nesting != part.getValue()) continue;
                ++msgCount;
            }
            return msgCount;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                PropertyValue.$$$reportNull$$$0(1);
            }
            if (capitalization == Nls.Capitalization.NotSpecified) {
                return true;
            }
            int parts = this.myPattern.countParts();
            int maxMsgCount = IntStreamEx.range((int)parts).map(i -> this.getMessagesForPart(i)).append(new int[]{1}).max().orElse(1);
            String string = this.myPattern.getPatternString();
            for (int curIndex = 0; curIndex < maxMsgCount; ++curIndex) {
                StringBuilder sample = new StringBuilder();
                int msgIndex = 0;
                int nestingLevel = 0;
                int curMsgCount = 0;
                boolean inMsg = false;
                for (int i2 = 1; i2 < parts; ++i2) {
                    boolean shouldCopyPart;
                    MessagePattern.Part part = this.myPattern.getPart(i2);
                    boolean bl = shouldCopyPart = nestingLevel == 0 || inMsg && msgIndex == curIndex % curMsgCount + 1;
                    if (shouldCopyPart) {
                        sample.append(string, this.myPattern.getPart(i2 - 1).getLimit(), this.myPattern.getPatternIndex(i2));
                    }
                    if (part.getType() == MessagePattern.Part.Type.ARG_START) {
                        ++nestingLevel;
                        MessagePattern.ArgType argType = part.getArgType();
                        if ((argType == MessagePattern.ArgType.SIMPLE || argType == MessagePattern.ArgType.NONE) && shouldCopyPart) {
                            sample.append("_");
                        }
                        msgIndex = 0;
                        curMsgCount = Math.max(1, this.getMessagesForPart(i2));
                        continue;
                    }
                    if (part.getType() == MessagePattern.Part.Type.MSG_START) {
                        ++msgIndex;
                        inMsg = true;
                        continue;
                    }
                    if (part.getType() == MessagePattern.Part.Type.MSG_LIMIT) {
                        inMsg = false;
                        continue;
                    }
                    if (part.getType() != MessagePattern.Part.Type.ARG_LIMIT) continue;
                    --nestingLevel;
                }
                if (NlsCapitalizationUtil.isCapitalizationSatisfied((String)sample.toString(), (Nls.Capitalization)capitalization)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canFix() {
            return IntStream.range(0, this.myPattern.countParts()).anyMatch(idx -> {
                MessagePattern.ArgType type = this.myPattern.getPart(idx).getArgType();
                return type == MessagePattern.ArgType.NONE || type == MessagePattern.ArgType.SIMPLE;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$PropertyValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$PropertyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSatisfied";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DeclaredValue
    implements Value {
        private final Nls.Capitalization myDeclared;

        DeclaredValue(Nls.Capitalization declared) {
            this.myDeclared = declared;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                DeclaredValue.$$$reportNull$$$0(0);
            }
            return capitalization == Nls.Capitalization.NotSpecified || capitalization == this.myDeclared;
        }

        @Override
        public boolean canFix() {
            return false;
        }

        @Override
        @NotNull
        public String toString() {
            String string = TitleCapitalizationInspection.getCapitalizationName(this.myDeclared);
            if (string == null) {
                DeclaredValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$DeclaredValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$DeclaredValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSatisfied";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TextValue
    implements Value {
        private final String myText;

        TextValue(String text) {
            this.myText = text;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myText;
            if (string == null) {
                TextValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                TextValue.$$$reportNull$$$0(1);
            }
            return NlsCapitalizationUtil.isCapitalizationSatisfied((String)StringUtil.stripHtml((String)this.myText, (boolean)true), (Nls.Capitalization)capitalization);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$TextValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$TextValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSatisfied";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface Value {
        @NotNull
        public String toString();

        public boolean isSatisfied(@NotNull Nls.Capitalization var1);

        @NotNull
        default public String fixCapitalization(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                Value.$$$reportNull$$$0(0);
            }
            String string = NlsCapitalizationUtil.fixValue((String)this.toString(), (Nls.Capitalization)capitalization);
            if (string == null) {
                Value.$$$reportNull$$$0(1);
            }
            return string;
        }

        default public boolean canFix() {
            return true;
        }

        @Contract(value="null, _ -> null")
        @Nullable
        public static Value of(@Nullable Property property, boolean useFormat) {
            if (property == null) {
                return null;
            }
            String value = property.getUnescapedValue();
            if (value == null) {
                return null;
            }
            if (useFormat) {
                try {
                    MessagePattern pattern = new MessagePattern(MessagePattern.ApostropheMode.DOUBLE_REQUIRED);
                    pattern.parse(value);
                    return new PropertyValue(value, pattern);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return new TextValue(value);
        }

        public static Value of(@NotNull UInjectionHost literal) {
            String value;
            if (literal == null) {
                Value.$$$reportNull$$$0(2);
            }
            return (value = literal.evaluateToString()) == null ? null : new TextValue(value);
        }

        @Nullable
        public static Value of(@NotNull PsiLiteralExpression literal) {
            Object value;
            if (literal == null) {
                Value.$$$reportNull$$$0(3);
            }
            return (value = literal.getValue()) instanceof String ? new TextValue((String)value) : null;
        }

        @Nullable
        public static Value of(NlsInfo info) {
            Nls.Capitalization capitalization;
            if (info instanceof NlsInfo.Localized && (capitalization = ((NlsInfo.Localized)info).getCapitalization()) != Nls.Capitalization.NotSpecified) {
                return new DeclaredValue(capitalization);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$Value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$Value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixCapitalization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fixCapitalization";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TitleCapitalizationFix
    implements LocalQuickFix {
        private final Value myTitleValue;
        private final Nls.Capitalization myCapitalization;

        TitleCapitalizationFix(Value titleValue, Nls.Capitalization capitalization) {
            this.myTitleValue = titleValue;
            this.myCapitalization = capitalization;
        }

        @NotNull
        public String getName() {
            String string = JavaI18nBundle.message("quickfix.text.title.capitalization", this.myTitleValue);
            if (string == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement problemElement;
            if (project == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(2);
            }
            if ((problemElement = descriptor.getPsiElement()) == null) {
                return;
            }
            this.doFix(project, problemElement);
        }

        protected void doFix(Project project, PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiLiteralExpression) {
                Value value = Value.of((PsiLiteralExpression)element);
                if (value == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression newExpression = factory.createExpressionFromText("\"" + StringUtil.escapeStringCharacters((String)value.fixCapitalization(this.myCapitalization)) + "\"", element);
                element.replace((PsiElement)newExpression);
            } else if (element instanceof PsiMethodCallExpression) {
                Property property;
                Value value;
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                PsiMethod method = call.resolveMethod();
                PsiExpression returnValue = PropertyUtilBase.getGetterReturnExpression((PsiMethod)method);
                if (returnValue != null) {
                    this.doFix(project, (PsiElement)returnValue);
                }
                if ((value = Value.of(property = TitleCapitalizationFix.getPropertyArgument(call), call.getArgumentList().getExpressionCount() > 1)) == null) {
                    return;
                }
                property.setValue(value.fixCapitalization(this.myCapitalization));
            } else if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (variable.hasModifierProperty("final")) {
                    this.doFix(project, (PsiElement)variable.getInitializer());
                }
            }
        }

        @Nullable
        private static Property getPropertyArgument(PsiMethodCallExpression arg) {
            PsiExpression[] args = arg.getArgumentList().getExpressions();
            if (args.length > 0) {
                return JavaI18nUtil.resolveProperty((PsiElement)args[0]);
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("quickfix.family.title.capitalization.fix", new Object[0]);
            if (string == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$TitleCapitalizationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/TitleCapitalizationInspection$TitleCapitalizationFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

