/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;

public class TextMateTextAttributesAdapter {
    private final TextAttributes myTextAttributes;
    private final double myForegroundAlpha;
    private final double myBackgroundAlpha;
    private final CharSequence myScopeName;

    public TextMateTextAttributesAdapter(@NotNull CharSequence scopeName, @NotNull TextMateTextAttributes attributes) {
        if (scopeName == null) {
            TextMateTextAttributesAdapter.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            TextMateTextAttributesAdapter.$$$reportNull$$$0(1);
        }
        this.myScopeName = scopeName;
        this.myTextAttributes = new TextAttributes();
        Pair<Color, Double> foreground = this.getColor(attributes.getForeground());
        this.myTextAttributes.setForegroundColor((Color)foreground.first);
        this.myForegroundAlpha = (Double)foreground.second;
        Pair<Color, Double> background = this.getColor(attributes.getBackground());
        this.myTextAttributes.setBackgroundColor((Color)background.first);
        this.myBackgroundAlpha = (Double)background.second;
        switch (attributes.getFontStyle()) {
            case PLAIN: {
                this.myTextAttributes.setFontType(0);
                break;
            }
            case ITALIC: {
                this.myTextAttributes.setFontType(2);
                break;
            }
            case BOLD: {
                this.myTextAttributes.setFontType(1);
                break;
            }
            case UNDERLINE: {
                TextAttributes defaultAttributes;
                Color foregroundColor = this.myTextAttributes.getForegroundColor();
                Color effectColor = foregroundColor != null ? foregroundColor : ((defaultAttributes = HighlighterColors.TEXT.getDefaultAttributes()) != null ? defaultAttributes.getForegroundColor() : null);
                this.myTextAttributes.setEffectColor(effectColor);
                this.myTextAttributes.setEffectType(EffectType.LINE_UNDERSCORE);
            }
        }
    }

    @NotNull
    public TextAttributesKey getTextAttributesKey(@NotNull TextMateTheme textMateTheme) {
        if (textMateTheme == null) {
            TextMateTextAttributesAdapter.$$$reportNull$$$0(2);
        }
        Color defaultBackground = textMateTheme.getDefaultBackground();
        Color mixedBackground = TextMateTextAttributesAdapter.mixBackground(defaultBackground, this.myTextAttributes.getBackgroundColor(), this.myBackgroundAlpha);
        Color mixedForeground = TextMateTextAttributesAdapter.mixBackground(defaultBackground, this.myTextAttributes.getForegroundColor(), this.myForegroundAlpha);
        if (mixedBackground == null && mixedForeground == null) {
            TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)("TextMateCustomRule_" + this.myScopeName), (TextAttributes)this.myTextAttributes);
            if (textAttributesKey == null) {
                TextMateTextAttributesAdapter.$$$reportNull$$$0(3);
            }
            return textAttributesKey;
        }
        TextAttributes result = new TextAttributes();
        result.copyFrom(this.myTextAttributes);
        if (mixedForeground != null) {
            this.myTextAttributes.setForegroundColor(mixedForeground);
        }
        if (mixedBackground != null) {
            this.myTextAttributes.setBackgroundColor(mixedBackground);
        }
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)("TextMateCustomRule_" + TextMateTheme.INSTANCE.getName() + this.myScopeName), (TextAttributes)result);
        if (textAttributesKey == null) {
            TextMateTextAttributesAdapter.$$$reportNull$$$0(4);
        }
        return textAttributesKey;
    }

    @Nullable
    private static Color mixBackground(@Nullable Color color, @Nullable Color defaultBackground, double alpha) {
        if (color == null || defaultBackground == null || alpha < 0.0) {
            return null;
        }
        return ColorUtil.mix((Color)defaultBackground, (Color)color, (double)alpha);
    }

    public Pair<Color, Double> getColor(@Nullable String s) {
        if (s == null) {
            return Pair.create(null, (Object)-1.0);
        }
        int startOffset = StringUtil.startsWithChar((CharSequence)s, (char)'#') ? 1 : 0;
        Color color = ColorUtil.fromHex((String)s.substring(startOffset, startOffset + 6), null);
        double alpha = s.length() > 7 ? TextMateTextAttributesAdapter.parseAlpha(s.substring(startOffset + 6)) : -1.0;
        return Pair.create((Object)color, (Object)alpha);
    }

    private static double parseAlpha(String string) {
        try {
            return (double)Integer.parseInt(string, 16) / 256.0;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textMateTheme";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTextAttributesAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTextAttributesAdapter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributesKey";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

