/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.util.Key;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenSpyOutputParser;

public class MavenSimpleConsoleEventsBuffer {
    private final StringBuilder myBuffer = new StringBuilder();
    private final BiConsumer<String, Key> myConsumer;
    private final boolean myShowSpyOutput;
    private boolean isProcessingSpyNow;

    public MavenSimpleConsoleEventsBuffer(BiConsumer<String, Key> consumer, boolean showSpyOutput) {
        this.myConsumer = consumer;
        this.myShowSpyOutput = showSpyOutput;
    }

    public void addText(@NotNull String text, @NotNull Key outputType) {
        String textToSend;
        boolean lastChunk;
        if (text == null) {
            MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(1);
        }
        if (this.myShowSpyOutput) {
            this.myConsumer.accept(text, outputType);
            return;
        }
        boolean bl = lastChunk = text.charAt(text.length() - 1) == '\n';
        if (this.isProcessingSpyNow) {
            this.myBuffer.setLength(0);
            this.isProcessingSpyNow = !lastChunk;
            return;
        }
        String string = textToSend = this.myBuffer.length() == 0 ? text : this.myBuffer + text;
        if (textToSend.length() >= "[IJ]-".length() || lastChunk) {
            this.myBuffer.setLength(0);
            if (!MavenSpyOutputParser.isSpyLog(textToSend)) {
                this.myConsumer.accept(textToSend, outputType);
            } else {
                this.isProcessingSpyNow = !lastChunk;
            }
        } else {
            this.myBuffer.append(text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outputType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/execution/MavenSimpleConsoleEventsBuffer";
        objectArray[2] = "addText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

