/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenContextlessPropertyReference
extends PsiReferenceBase<PsiElement> {
    private final XmlTag myProperties;

    public MavenContextlessPropertyReference(@NotNull XmlTag properties, @NotNull PsiElement element, @NotNull TextRange range, boolean isSoft) {
        if (properties == null) {
            MavenContextlessPropertyReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            MavenContextlessPropertyReference.$$$reportNull$$$0(1);
        }
        if (range == null) {
            MavenContextlessPropertyReference.$$$reportNull$$$0(2);
        }
        super(element, range, isSoft);
        this.myProperties = properties;
    }

    @Nullable
    public PsiElement resolve() {
        String value = this.getValue();
        for (XmlTag subTag : this.myProperties.getSubTags()) {
            if (!value.equals(subTag.getName())) continue;
            return subTag;
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        String skippedPropertyName = null;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class, (boolean)false);
        if (xmlTag != null && this.myProperties == xmlTag.getParentTag()) {
            skippedPropertyName = xmlTag.getName();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (XmlTag subTag : this.myProperties.getSubTags()) {
            String name = subTag.getName();
            if (name.equals(skippedPropertyName)) continue;
            res.add(name);
        }
        Object[] objectArray = res.toArray();
        if (objectArray == null) {
            MavenContextlessPropertyReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenContextlessPropertyReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenContextlessPropertyReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

