/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JulLogger
extends Logger {
    protected final java.util.logging.Logger myLogger;

    public JulLogger(java.util.logging.Logger delegate) {
        this.myLogger = delegate;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.myLogger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLogger.isLoggable(Level.FINER);
    }

    @Override
    public void debug(String message) {
        this.myLogger.log(Level.FINE, message);
    }

    @Override
    public void debug(@Nullable Throwable t) {
        this.myLogger.log(Level.FINE, "", t);
    }

    @Override
    public void debug(String message, @Nullable Throwable t) {
        this.myLogger.log(Level.FINE, message, t);
    }

    @Override
    public void trace(String message) {
        this.myLogger.log(Level.FINER, message);
    }

    @Override
    public void trace(@Nullable Throwable t) {
        this.myLogger.log(Level.FINER, "", t);
    }

    @Override
    public void info(String message) {
        this.myLogger.log(Level.INFO, message);
    }

    @Override
    public void info(String message, @Nullable Throwable t) {
        this.myLogger.log(Level.INFO, message, t);
    }

    @Override
    public void warn(String message, @Nullable Throwable t) {
        this.myLogger.log(Level.WARNING, message, t);
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            JulLogger.$$$reportNull$$$0(0);
        }
        String fullMessage = details.length > 0 ? message + "\nDetails: " + String.join((CharSequence)"\n", details) : message;
        this.myLogger.log(Level.SEVERE, fullMessage, t);
    }

    @Override
    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            JulLogger.$$$reportNull$$$0(1);
        }
        this.myLogger.setLevel(level.getLevel());
    }

    @Override
    public void setLevel(@NotNull org.apache.log4j.Level level) {
        if (level == null) {
            JulLogger.$$$reportNull$$$0(2);
        }
        switch (level.toInt()) {
            case 0x7FFFFFFF: {
                this.myLogger.setLevel(Level.OFF);
                break;
            }
            case 40000: 
            case 50000: {
                this.myLogger.setLevel(Level.SEVERE);
                break;
            }
            case 30000: {
                this.myLogger.setLevel(Level.WARNING);
                break;
            }
            case 20000: {
                this.myLogger.setLevel(Level.INFO);
                break;
            }
            case 10000: {
                this.myLogger.setLevel(Level.FINE);
                break;
            }
            case 5000: {
                this.myLogger.setLevel(Level.FINER);
                break;
            }
            case -2147483648: {
                this.myLogger.setLevel(Level.ALL);
            }
        }
    }

    public static void clearHandlers() {
        JulLogger.clearHandlers(java.util.logging.Logger.getLogger(""));
    }

    public static void clearHandlers(java.util.logging.Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    public static void configureLogFileAndConsole(@NotNull Path logFilePath, boolean appendToFile, boolean showDateInConsole, boolean enableConsoleLogger, @Nullable Runnable onRotate) {
        if (logFilePath == null) {
            JulLogger.$$$reportNull$$$0(3);
        }
        long limit = 10000000L;
        String limitProp = System.getProperty("idea.log.limit");
        if (limitProp != null) {
            try {
                limit = Long.parseLong(limitProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int count = 12;
        String countProp = System.getProperty("idea.log.count");
        if (countProp != null) {
            try {
                count = Integer.parseInt(countProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean logConsole = SystemProperties.getBooleanProperty("idea.log.console", true);
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        RollingFileHandler fileHandler = new RollingFileHandler(logFilePath, limit, count, appendToFile, onRotate);
        fileHandler.setLevel(Level.FINEST);
        IdeaLogRecordFormatter layout = new IdeaLogRecordFormatter();
        fileHandler.setFormatter(layout);
        rootLogger.addHandler(fileHandler);
        if (enableConsoleLogger && logConsole) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new IdeaLogRecordFormatter(layout, showDateInConsole));
            consoleHandler.setLevel(Level.WARNING);
            rootLogger.addHandler(consoleHandler);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFilePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diagnostic/JulLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureLogFileAndConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

