/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.auth.services.OAuthServiceBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.RequestKt;
import org.jetbrains.qodana.cloud.RequestMethod;
import org.jetbrains.qodana.cloud.RequestResponse;
import org.jetbrains.qodana.cloud.authorization.OauthKt;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudCredentials;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f2\n\u0010\r\u001a\u00060\u0006j\u0002`\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthServiceImpl;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudCredentials;", "Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthService;", "()V", "name", "", "getName", "()Ljava/lang/String;", "cancelAuthorization", "", "refreshCredentials", "Ljava/util/concurrent/CompletableFuture;", "refreshToken", "Lorg/jetbrains/qodana/cloud/authorization/QodanaRefreshToken;", "revokeToken", "", "token", "intellij.qodana"})
public final class QodanaCloudOAuthServiceImpl
extends OAuthServiceBase<QodanaCloudCredentials>
implements QodanaCloudOAuthService {
    @NotNull
    private final String name;

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CompletableFuture<QodanaCloudCredentials> refreshCredentials(@NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        return CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, (ProgressIndicator)new EmptyProgressIndicator(), (Function1)new Function1<ProgressIndicator, QodanaCloudCredentials>(this, refreshToken){
            final /* synthetic */ QodanaCloudOAuthServiceImpl this$0;
            final /* synthetic */ String $refreshToken;

            @Nullable
            public final QodanaCloudCredentials invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                QodanaCloudOAuthServiceImpl $this$thisLogger$iv = this.this$0;
                boolean $i$f$thisLogger22 = false;
                Logger logger = Logger.getInstance(QodanaCloudOAuthServiceImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.info("Refreshing Qodana Cloud Credentials");
                RequestMethod $i$f$thisLogger22 = new RequestMethod.POST(null, 1, null);
                Map map = null;
                String string = this.$refreshToken;
                HttpRequest refreshRequest = RequestKt.buildRequestToQodanaCloud$default("/v1/idea/auth/refresh/", $i$f$thisLogger22, map, string, 4, null);
                RequestResponse<QodanaCloudCredentials> response2 = OauthKt.getCredentialsByHttpRequest(refreshRequest);
                if (response2 instanceof RequestResponse.Success) {
                    return (QodanaCloudCredentials)((RequestResponse.Success)response2).getResult();
                }
                if (!(response2 instanceof RequestResponse.Error)) {
                    throw new NoWhenBranchMatchedException();
                }
                QodanaCloudOAuthServiceImpl $this$thisLogger$iv2 = this.this$0;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(QodanaCloudOAuthServiceImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                logger2.warn("Can't update credentials with refresh token, code:" + ((RequestResponse.Error)response2).getResponseCode() + " message: " + response2);
                return null;
            }
            {
                this.this$0 = qodanaCloudOAuthServiceImpl;
                this.$refreshToken = string;
                super(1);
            }
        });
    }

    @Override
    public boolean cancelAuthorization() {
        Object object = (OAuthServiceBase.OAuthRequestWithResult)this.getCurrentRequest().get();
        return object != null && (object = object.getResult()) != null ? ((CompletableFuture)object).cancel(true) : false;
    }

    public void revokeToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
    }

    public QodanaCloudOAuthServiceImpl() {
        this.name = "qodana/oauth";
    }
}

