/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.QodanaCloudUrls;
import org.jetbrains.qodana.cloud.RequestMethod;
import org.jetbrains.qodana.cloud.RequestResponse;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0000\u001aT\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\u000126\u0010\r\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u0003*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0007H\u0002\u00a8\u0006\u0015"}, d2={"buildRequestToQodanaCloud", "Ljava/net/http/HttpRequest;", "path", "", "requestMethod", "Lorg/jetbrains/qodana/cloud/RequestMethod;", "headers", "", "authToken", "sendRequest", "Lorg/jetbrains/qodana/cloud/RequestResponse;", "T", "request", "responseProcessor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "body", "Ljava/net/http/HttpHeaders;", "toJson", "", "intellij.qodana"})
public final class RequestKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpRequest buildRequestToQodanaCloud(@NotNull String path, @NotNull RequestMethod requestMethod, @NotNull Map<String, String> headers, @Nullable String authToken) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Url url = Urls.newFromEncoded((String)(QodanaCloudUrls.Companion.getInstance().getCloudApi() + path));
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(url.toExternalForm())).header("Content-Type", "application/json");
        Object object = headers;
        if (!object.isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            Collection $this$flatMap$iv;
            object = headers;
            HttpRequest.Builder builder = requestBuilder;
            boolean $i$f$flatMap = false;
            void var8_9 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])new String[]{(String)it.getKey(), (String)it.getValue()});
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            $this$flatMap$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            builder.headers(Arrays.copyOf(stringArray, stringArray.length));
        }
        if (authToken != null) {
            requestBuilder.header("Authorization", "Bearer " + authToken);
        }
        if ((object = requestMethod) instanceof RequestMethod.GET) {
            requestBuilder.GET();
        } else if (object instanceof RequestMethod.POST) {
            requestBuilder.POST(HttpRequest.BodyPublishers.ofString(RequestKt.toJson(((RequestMethod.POST)requestMethod).getBody())));
        }
        HttpRequest httpRequest = requestBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"requestBuilder.build()");
        return httpRequest;
    }

    public static /* synthetic */ HttpRequest buildRequestToQodanaCloud$default(String string, RequestMethod requestMethod, Map map, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return RequestKt.buildRequestToQodanaCloud(string, requestMethod, map, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> RequestResponse<T> sendRequest(@NotNull HttpRequest request, @NotNull Function2<? super String, ? super HttpHeaders, ? extends T> responseProcessor) {
        RequestResponse requestResponse;
        void responseCode;
        HttpResponse<String> httpResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseProcessor, (String)"responseProcessor");
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
        try {
            httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            return new RequestResponse.Error(null, "Can't get credentials " + e);
        }
        HttpResponse<String> response2 = httpResponse;
        int n = response2.statusCode();
        switch (responseCode) {
            case 200: {
                String string = response2.body();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.body()");
                HttpHeaders httpHeaders = response2.headers();
                Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"response.headers()");
                requestResponse = new RequestResponse.Success<Object>(responseProcessor.invoke((Object)string, (Object)httpHeaders));
                break;
            }
            default: {
                Integer n2 = (int)responseCode;
                String string = response2.body();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.body()");
                requestResponse = new RequestResponse.Error(n2, string);
            }
        }
        return requestResponse;
    }

    private static final String toJson(Map<String, ? extends Object> $this$toJson) {
        String string = ExtensionsKt.jacksonObjectMapper().writeValueAsString($this$toJson);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonObjectMapper().writeValueAsString(this)");
        return string;
    }
}

