/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.registry.QodanaRegistry;
import org.jetbrains.qodana.ui.QodanaCloudSettingsPanel;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/actions/OpenQodanaCloudSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.qodana"})
public final class OpenQodanaCloudSettingsAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        QodanaCloudStateService.UserState userState = QodanaCloudStateService.Companion.getInstance().getUserState();
        if (userState instanceof QodanaCloudStateService.Authorized) {
            QodanaCloudStateService.Companion.getInstance().logOut();
        } else {
            QodanaCloudSettingsPanel.Companion.openSettings(e.getProject());
        }
    }

    public OpenQodanaCloudSettingsAction() {
        Function0 function0 = (Function0)new Function0<String>(Companion){

            @NotNull
            public final String invoke() {
                return ((Companion)this.receiver).actionNameProvider();
            }
        };
        super(new Supplier(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/actions/OpenQodanaCloudSettingsAction$Companion;", "", "()V", "actionNameProvider", "", "create", "Lcom/intellij/openapi/project/DumbAwareAction;", "intellij.qodana"})
    public static final class Companion {
        @Nullable
        public final DumbAwareAction create() {
            return QodanaRegistry.INSTANCE.getQodanaCloudIntegrationEnabled().asBoolean() ? (DumbAwareAction)new OpenQodanaCloudSettingsAction() : null;
        }

        private final String actionNameProvider() {
            String string;
            QodanaCloudStateService.UserState userState = QodanaCloudStateService.Companion.getInstance().getUserState();
            if (userState instanceof QodanaCloudStateService.Authorized) {
                String string2 = QodanaBundle.message("qodana.open.settings.log.out", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"qo\u2026a.open.settings.log.out\")");
            } else if (userState instanceof QodanaCloudStateService.Authorizing) {
                String string3 = QodanaBundle.message("qodana.open.settings.connecting", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"QodanaBundle.message(\"qo\u2026pen.settings.connecting\")");
            } else if (userState instanceof QodanaCloudStateService.NotAuthorized) {
                String string4 = QodanaBundle.message("qodana.open.settings.log.in", new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"QodanaBundle.message(\"qo\u2026na.open.settings.log.in\")");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

