/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.safeDelete;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;

public class JavaSafeDeleteDelegateForGroovy
implements JavaSafeDeleteDelegate {
    public void createUsageInfoForParameter(@NotNull PsiReference reference, @NotNull List<UsageInfo> usages, @NotNull PsiParameter parameter, final @NotNull PsiMethod method) {
        if (reference == null) {
            JavaSafeDeleteDelegateForGroovy.$$$reportNull$$$0(0);
        }
        if (usages == null) {
            JavaSafeDeleteDelegateForGroovy.$$$reportNull$$$0(1);
        }
        if (parameter == null) {
            JavaSafeDeleteDelegateForGroovy.$$$reportNull$$$0(2);
        }
        if (method == null) {
            JavaSafeDeleteDelegateForGroovy.$$$reportNull$$$0(3);
        }
        int index = method.getParameterList().getParameterIndex(parameter);
        final PsiElement element = reference.getElement();
        GrCall call = null;
        if (element instanceof GrCall) {
            call = (GrCall)element;
        } else if (element.getParent() instanceof GrCall) {
            call = (GrCall)element.getParent();
        }
        if (call != null) {
            GrSignature signature = GrClosureSignatureUtil.createSignature(call);
            if (signature == null) {
                return;
            }
            GrClosureSignatureUtil.ArgInfo<PsiElement>[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call);
            if (argInfos == null) {
                return;
            }
            for (PsiElement arg : argInfos[index].args) {
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(arg, (PsiElement)parameter, true));
            }
        } else if (element instanceof GrDocMethodReference) {
            final @NonNls StringBuilder newText = new StringBuilder();
            newText.append("/** @see ");
            GrDocReferenceElement holder = ((GrDocMethodReference)element).getReferenceHolder();
            if (holder != null) {
                newText.append(holder.getText());
            }
            newText.append('#');
            newText.append(method.getName());
            newText.append('(');
            ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>(Arrays.asList(method.getParameterList().getParameters()));
            parameters2.remove(parameter);
            newText.append(StringUtil.join(parameters2, psiParameter -> parameter.getType().getCanonicalText(), (String)","));
            newText.append(")*/");
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, true){

                public void deleteElement() throws IncorrectOperationException {
                    ((GrDocMethodReference)element).bindToText(method.getProject(), newText.toString());
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "reference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "usages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parameter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/refactoring/safeDelete/JavaSafeDeleteDelegateForGroovy";
        objectArray[2] = "createUsageInfoForParameter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

