/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrClassMemberReferenceVisitor;

public class GrDependantMembersCollector
extends DependentMembersCollectorBase<GrMember, PsiClass> {
    public GrDependantMembersCollector(PsiClass clazz, PsiClass superClass) {
        super((Object)clazz, (Object)superClass);
    }

    public void collect(GrMember member) {
        member.accept(new GrClassMemberReferenceVisitor((PsiClass)this.getClazz()){

            @Override
            protected void visitClassMemberReferenceElement(GrMember classMember, GrReferenceElement ref) {
                if (!GrDependantMembersCollector.this.existsInSuperClass(classMember)) {
                    GrDependantMembersCollector.this.myCollection.add(classMember);
                }
            }
        });
    }

    private boolean existsInSuperClass(PsiMember classMember) {
        if (this.getSuperClass() == null) {
            return false;
        }
        if (!(classMember instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)classMember;
        PsiMethod methodBySignature = ((PsiClass)this.getSuperClass()).findMethodBySignature(method, true);
        return methodBySignature != null;
    }
}

