/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind;", "", "jarsPath", "", "subPaths", "", "pattern", "Ljava/util/regex/Pattern;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/regex/Pattern;)V", "getJarsPath", "()Ljava/lang/String;", "getPattern", "()Ljava/util/regex/Pattern;", "getSubPaths", "()Ljava/util/List;", "Companion", "Embeddable", "Jar", "Lib", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Jar;", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Lib;", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Embeddable;", "intellij.groovy.psi"})
public abstract class GroovyHomeKind {
    @NotNull
    private final String jarsPath;
    @NotNull
    private final List<String> subPaths;
    @NotNull
    private final Pattern pattern;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getJarsPath() {
        return this.jarsPath;
    }

    @NotNull
    public final List<String> getSubPaths() {
        return this.subPaths;
    }

    @NotNull
    public final Pattern getPattern() {
        return this.pattern;
    }

    private GroovyHomeKind(String jarsPath, List<String> subPaths, Pattern pattern) {
        this.jarsPath = jarsPath;
        this.subPaths = subPaths;
        this.pattern = pattern;
    }

    public /* synthetic */ GroovyHomeKind(String jarsPath, List subPaths, Pattern pattern, DefaultConstructorMarker $constructor_marker) {
        this(jarsPath, subPaths, pattern);
    }

    @JvmStatic
    @Nullable
    public static final GroovyHomeKind fromString(@NotNull String path) {
        return Companion.fromString(path);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Jar;", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind;", "path", "", "(Ljava/lang/String;)V", "intellij.groovy.psi"})
    public static final class Jar
    extends GroovyHomeKind {
        public Jar(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            List list = CollectionsKt.listOf((Object)"*.jar");
            Pattern pattern = GroovyConfigUtils.GROOVY_JAR_PATTERN;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GroovyConfigUtils.GROOVY_JAR_PATTERN");
            super(path, list, pattern, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Lib;", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind;", "path", "", "(Ljava/lang/String;)V", "intellij.groovy.psi"})
    public static final class Lib
    extends GroovyHomeKind {
        public Lib(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = path + "/lib";
            List list = CollectionsKt.listOf((Object[])new String[]{"*.jar", "*/*.jar"});
            Pattern pattern = GroovyConfigUtils.GROOVY_JAR_PATTERN;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GroovyConfigUtils.GROOVY_JAR_PATTERN");
            super(string, list, pattern, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Embeddable;", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind;", "path", "", "(Ljava/lang/String;)V", "intellij.groovy.psi"})
    public static final class Embeddable
    extends GroovyHomeKind {
        public Embeddable(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = path + "/embeddable";
            List list = CollectionsKt.listOf((Object[])new String[]{"*.jar", "*/*.jar"});
            Pattern pattern = GroovyConfigUtils.GROOVY_ALL_JAR_PATTERN;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GroovyConfigUtils.GROOVY_ALL_JAR_PATTERN");
            super(string, list, pattern, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind$Companion;", "", "()V", "fromString", "Lorg/jetbrains/plugins/groovy/config/GroovyHomeKind;", "path", "", "intellij.groovy.psi"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GroovyHomeKind fromString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return LibrariesUtil.getFilesInDirectoryByPattern(path + "/lib", GroovyConfigUtils.GROOVY_JAR_PATTERN).length > 0 ? (GroovyHomeKind)new Lib(path) : (LibrariesUtil.getFilesInDirectoryByPattern(path + "/embeddable", GroovyConfigUtils.GROOVY_ALL_JAR_PATTERN).length > 0 ? (GroovyHomeKind)new Embeddable(path) : (GroovyHomeKind)(LibrariesUtil.getFilesInDirectoryByPattern(path, GroovyConfigUtils.GROOVY_JAR_PATTERN).length > 0 ? new Jar(path) : null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

