/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.CatchParameterUsedVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.GrExceptionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyUnusedCatchParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        @NlsSafe
        private static final String IGNORED = "ignored";

        private Visitor() {
        }

        @Override
        public void visitCatchClause(@NotNull GrCatchClause catchClause) {
            if (catchClause == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitCatchClause(catchClause);
            GrOpenBlock block = catchClause.getBody();
            if (block == null) {
                return;
            }
            GrParameter parameter = catchClause.getParameter();
            if (parameter == null) {
                return;
            }
            if (GrExceptionUtil.ignore(parameter)) {
                return;
            }
            CatchParameterUsedVisitor visitor2 = new CatchParameterUsedVisitor(parameter);
            block.accept(visitor2);
            if (!visitor2.isUsed()) {
                PsiElement nameIdentifier = parameter.getNameIdentifierGroovy();
                this.registerError(nameIdentifier, GroovyBundle.message("inspection.message.unused.catch.parameter.ref", new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)parameter, IGNORED)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchClause", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection$Visitor", "visitCatchClause"));
        }
    }
}

