/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrRemoveExceptionFix
implements IntentionAction {
    @IntentionName
    private final String myText;
    private final boolean myDisjunction;

    public GrRemoveExceptionFix(boolean isDisjunction) {
        this.myDisjunction = isDisjunction;
        this.myText = isDisjunction ? GroovyBundle.message("remove.exception", new Object[0]) : GroovyBundle.message("remove.catch.block", new Object[0]);
    }

    @NotNull
    @IntentionName
    public String getText() {
        String string = this.myText;
        if (string == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("try.catch.fix", new Object[0]);
        if (string == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(2);
        }
        return this.myDisjunction && GrRemoveExceptionFix.findTypeElementInDisjunction(editor, file) != null || !this.myDisjunction && GrRemoveExceptionFix.findCatch(editor, file) != null;
    }

    @Nullable
    private static GrTypeElement findTypeElementInDisjunction(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        GrDisjunctionTypeElement disjunction = (GrDisjunctionTypeElement)PsiTreeUtil.getParentOfType((PsiElement)at, GrDisjunctionTypeElement.class);
        if (disjunction == null) {
            return null;
        }
        for (GrTypeElement element : disjunction.getTypeElements()) {
            if (!element.getTextRange().contains(offset)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static GrCatchClause findCatch(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        return (GrCatchClause)PsiTreeUtil.getParentOfType((PsiElement)at, GrCatchClause.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(3);
        }
        if (this.myDisjunction) {
            GrTypeElement element = GrRemoveExceptionFix.findTypeElementInDisjunction(editor, file);
            if (element != null) {
                element.delete();
            }
        } else {
            GrCatchClause aCatch = GrRemoveExceptionFix.findCatch(editor, file);
            if (aCatch != null) {
                aCatch.delete();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrRemoveExceptionFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrRemoveExceptionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

