/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension.postfix;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import de.plushnikov.intellij.plugin.extension.postfix.IntroduceVariableSettingsDelegate;

public class IntroduceLombokVariableHandler
extends IntroduceVariableHandler {
    private final String selectedTypeFQN;

    IntroduceLombokVariableHandler(String selectedTypeFQN) {
        this.selectedTypeFQN = selectedTypeFQN;
    }

    public IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator, PsiElement anchor, IntroduceVariableBase.JavaReplaceChoice replaceChoice) {
        UnitTestMockVariableSettings variableSettings = ApplicationManager.getApplication().isUnitTestMode() ? new UnitTestMockVariableSettings(expr) : super.getSettings(project, editor, expr, occurrences, typeSelectorManager, declareFinalIfAll, anyAssignmentLHS, validator, anchor, replaceChoice);
        return this.getIntroduceVariableSettings(project, variableSettings);
    }

    private IntroduceVariableSettings getIntroduceVariableSettings(Project project, IntroduceVariableSettings variableSettings) {
        PsiClassType psiClassType = PsiType.getTypeByName((String)this.selectedTypeFQN, (Project)project, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        if (null != psiClassType) {
            return new IntroduceVariableSettingsDelegate(variableSettings, psiClassType);
        }
        return variableSettings;
    }

    private static class UnitTestMockVariableSettings
    implements IntroduceVariableSettings {
        private final PsiExpression expr;

        UnitTestMockVariableSettings(PsiExpression expr) {
            this.expr = expr;
        }

        public String getEnteredName() {
            return "foo";
        }

        public boolean isReplaceAllOccurrences() {
            return false;
        }

        public boolean isDeclareFinal() {
            return false;
        }

        public boolean isReplaceLValues() {
            return false;
        }

        public PsiType getSelectedType() {
            return this.expr.getType();
        }

        public boolean isOK() {
            return true;
        }
    }
}

