/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollectorKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModuleKt;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleWrapperTranslation;", "", "()V", "addModuleValidation", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "currentModuleId", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "makePlainInvocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleId", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "importedModules", "", "makePlainModuleRef", "wrap", "kind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "wrapAmd", "wrapCommonJs", "wrapPlain", "wrapUmd", "Namer", "backend.js"})
public final class ModuleWrapperTranslation {
    @NotNull
    public static final ModuleWrapperTranslation INSTANCE = new ModuleWrapperTranslation();

    private ModuleWrapperTranslation() {
    }

    @NotNull
    public final List<JsStatement> wrap(@NotNull String moduleId, @NotNull JsExpression function2, @NotNull List<JsImportedModule> importedModules, @NotNull JsProgram program, @NotNull ModuleKind kind) {
        List<JsStatement> list2;
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(importedModules, (String)"importedModules");
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                list2 = this.wrapAmd(function2, importedModules, program);
                break;
            }
            case 2: {
                list2 = this.wrapCommonJs(function2, importedModules, program);
                break;
            }
            case 3: {
                list2 = this.wrapUmd(moduleId, function2, importedModules, program);
                break;
            }
            case 4: {
                list2 = this.wrapPlain(moduleId, function2, importedModules, program);
                break;
            }
            case 5: {
                throw new IllegalStateException("ES modules are not supported in legacy wrapper".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<JsStatement> wrapUmd(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsExpression[] jsExpressionArray;
        JsObjectScope scope = program.getScope();
        JsName jsName = scope.declareName("define");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        JsName jsName2 = scope.declareName("exports");
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"scope.declareName(\"exports\")");
        JsName exportsName = jsName2;
        JsBlock adapterBody = new JsBlock();
        JsFunction adapter = new JsFunction((JsScope)program.getScope(), adapterBody, "Adapter");
        JsName jsName3 = adapter.getScope().declareName("root");
        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"adapter.scope.declareName(\"root\")");
        JsName rootName = jsName3;
        JsName jsName4 = adapter.getScope().declareName("factory");
        Intrinsics.checkNotNullExpressionValue((Object)jsName4, (String)"adapter.scope.declareName(\"factory\")");
        JsName factoryName = jsName4;
        List<JsParameter> list2 = adapter.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"adapter.parameters");
        Collection collection = list2;
        collection.add(new JsParameter(rootName));
        List<JsParameter> list3 = adapter.getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"adapter.parameters");
        collection = list3;
        collection.add(new JsParameter(factoryName));
        JsNameRef jsNameRef = defineName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"defineName.makeRef()");
        JsBinaryOperation amdTest = JsAstUtils.INSTANCE.and(JsAstUtils.INSTANCE.typeOfIs(jsNameRef, new JsStringLiteral("function")), new JsNameRef("amd", (JsExpression)defineName.makeRef()));
        JsNameRef jsNameRef2 = exportsName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"exportsName.makeRef()");
        JsBinaryOperation commonJsTest = JsAstUtils.INSTANCE.typeOfIs(jsNameRef2, new JsStringLiteral("object"));
        JsNameRef jsNameRef3 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef3, (String)"factoryName.makeRef()");
        JsBlock amdBody = new JsBlock(this.wrapAmd(jsNameRef3, importedModules, program));
        JsNameRef jsNameRef4 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef4, (String)"factoryName.makeRef()");
        JsBlock commonJsBody = new JsBlock(this.wrapCommonJs(jsNameRef4, importedModules, program));
        JsNameRef jsNameRef5 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef5, (String)"factoryName.makeRef()");
        JsInvocation plainInvocation = this.makePlainInvocation(moduleId, jsNameRef5, importedModules, program);
        JsExpression lhs = Namer.INSTANCE.requiresEscaping(moduleId) ? (JsExpression)new JsArrayAccess(rootName.makeRef(), new JsStringLiteral(moduleId)) : (JsExpression)new JsNameRef(scope.declareName(moduleId), (JsExpression)rootName.makeRef());
        JsBlock plainBlock = new JsBlock();
        for (JsImportedModule importedModule : importedModules) {
            List<JsStatement> list4 = plainBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"plainBlock.statements");
            jsExpressionArray = (JsExpression[])list4;
            jsExpressionArray.add(this.addModuleValidation(moduleId, program, importedModule));
        }
        List<JsStatement> list5 = plainBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"plainBlock.statements");
        Collection collection2 = list5;
        collection2.add(JsAstUtils.INSTANCE.assignment(lhs, plainInvocation).makeStmt());
        JsIf selector = JsAstUtils.INSTANCE.newJsIf(amdTest, amdBody, JsAstUtils.INSTANCE.newJsIf(commonJsTest, commonJsBody, plainBlock));
        List<JsStatement> list6 = adapterBody.getStatements();
        Intrinsics.checkNotNullExpressionValue(list6, (String)"adapterBody.statements");
        ((Collection)list6).add(selector);
        jsExpressionArray = new JsExpression[]{new JsThisRef(), function2};
        JsStatement jsStatement = new JsInvocation((JsExpression)adapter, jsExpressionArray).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"JsInvocation(adapter, Js\u2026f(), function).makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapAmd(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        Collection<JsStringLiteral> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsObjectScope scope = program.getScope();
        JsName jsName = scope.declareName("define");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"scope.declareName(\"define\")");
        JsName defineName = jsName;
        Object[] objectArray = new JsExpression[2];
        Iterable iterable = importedModules;
        Collection collection2 = CollectionsKt.listOf((Object)new JsStringLiteral("exports"));
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JsStringLiteral(JsImportedModuleKt.getRequireName((JsImportedModule)it)));
        }
        collection = (List)destination$iv$iv;
        List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        objectArray2[n] = new JsArrayLiteral(list2);
        objectArray[1] = function2;
        List invocationArgs = CollectionsKt.listOf((Object[])objectArray);
        JsInvocation invocation = new JsInvocation((JsExpression)defineName.makeRef(), invocationArgs);
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"invocation.makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapCommonJs(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        JsObjectScope scope = program.getScope();
        JsName jsName = scope.declareName("module");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"scope.declareName(\"module\")");
        JsName moduleName = jsName;
        JsName jsName2 = scope.declareName("require");
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"scope.declareName(\"require\")");
        JsName requireName = jsName2;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsStringLiteral(JsImportedModuleKt.getRequireName((JsImportedModule)it))};
            collection.add(new JsInvocation((JsExpression)requireName.makeRef(), jsExpressionArray));
        }
        List invocationArgs = (List)destination$iv$iv;
        JsInvocation invocation = new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new JsNameRef("exports", (JsExpression)moduleName.makeRef())), (Iterable)invocationArgs));
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"invocation.makeStmt()");
        return CollectionsKt.listOf((Object)jsStatement);
    }

    private final List<JsStatement> wrapPlain(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsStatement jsStatement;
        JsInvocation invocation = this.makePlainInvocation(moduleId, function2, importedModules, program);
        List statements = new ArrayList();
        for (JsImportedModule importedModule : importedModules) {
            ((Collection)statements).add(this.addModuleValidation(moduleId, program, importedModule));
        }
        Collection collection = statements;
        if (Namer.INSTANCE.requiresEscaping(moduleId)) {
            jsStatement = JsAstUtils.INSTANCE.assignment(this.makePlainModuleRef(moduleId, program), invocation).makeStmt();
        } else {
            JsName jsName = program.getRootScope().declareName(moduleId);
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"program.rootScope.declareName(moduleId)");
            jsStatement = JsAstUtils.INSTANCE.newVar(jsName, invocation);
        }
        JsStatement jsStatement2 = jsStatement;
        collection.add(jsStatement2);
        return statements;
    }

    private final JsStatement addModuleValidation(String currentModuleId, JsProgram program, JsImportedModule module) {
        JsExpression moduleRef = this.makePlainModuleRef(module, program);
        JsBinaryOperation moduleExistsCond = JsAstUtils.INSTANCE.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        JsStringLiteral moduleNotFoundMessage = new JsStringLiteral("Error loading module '" + currentModuleId + "'. Its dependency '" + module.getExternalName() + "' was not found. Please, check whether '" + module.getExternalName() + "' is loaded prior to '" + currentModuleId + "'.");
        JsThrow moduleNotFoundThrow = new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf((Object)moduleNotFoundMessage)));
        return new JsIf(moduleExistsCond, new JsBlock((JsStatement)moduleNotFoundThrow));
    }

    /*
     * WARNING - void declaration
     */
    private final JsInvocation makePlainInvocation(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.makePlainModuleRef((JsImportedModule)it, program));
        }
        List invocationArgs = (List)destination$iv$iv;
        JsExpression moduleRef = this.makePlainModuleRef(moduleId, program);
        JsBinaryOperation testModuleDefined = JsAstUtils.INSTANCE.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        JsConditional selfArg = new JsConditional(testModuleDefined, new JsObjectLiteral(false), moduleRef.deepCopy());
        return new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)selfArg), (Iterable)invocationArgs));
    }

    private final JsExpression makePlainModuleRef(JsImportedModule module, JsProgram program) {
        JsExpression jsExpression = module.getPlainReference();
        if (jsExpression == null) {
            jsExpression = this.makePlainModuleRef(module.getExternalName(), program);
        }
        return jsExpression;
    }

    private final JsExpression makePlainModuleRef(String moduleId, JsProgram program) {
        JsExpression jsExpression;
        if (Namer.INSTANCE.requiresEscaping(moduleId)) {
            jsExpression = new JsArrayAccess(new JsThisRef(), new JsStringLiteral(moduleId));
        } else {
            JsNameRef jsNameRef = program.getScope().declareName(moduleId).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"{\n            program.sc\u2026leId).makeRef()\n        }");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleWrapperTranslation$Namer;", "", "()V", "requiresEscaping", "", "name", "", "backend.js"})
    public static final class Namer {
        @NotNull
        public static final Namer INSTANCE = new Namer();

        private Namer() {
        }

        public final boolean requiresEscaping(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return !IdentifierPolicyKt.isValidES5Identifier(name) || StableNamesCollectorKt.getRESERVED_IDENTIFIERS().contains(name);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleKind.values().length];
            nArray[ModuleKind.AMD.ordinal()] = 1;
            nArray[ModuleKind.COMMON_JS.ordinal()] = 2;
            nArray[ModuleKind.UMD.ordinal()] = 3;
            nArray[ModuleKind.PLAIN.ordinal()] = 4;
            nArray[ModuleKind.ES.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

