/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeepCopyIrTreeWithDeclarationsKt;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0011H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010(\u001a\u00020\b*\u00020\"H\u0002J\u0014\u0010)\u001a\u00020'*\u00020*2\u0006\u0010+\u001a\u00020'H\u0002J\u0014\u0010,\u001a\u00020'*\u00020*2\u0006\u0010-\u001a\u00020'H\u0002J\f\u0010.\u001a\u00020\"*\u00020\"H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "jvmContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "inInlineFunctionScope", "", "getInInlineFunctionScope", "()Z", "getJvmContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "publicAnnotationImplementationClasses", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateFunctionBodies", "", "annotationClass", "eqFun", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hcFun", "toStringFun", "generator", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationMemberGenerator;", "getArrayContentEqualsSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "implementAnnotationPropertiesAndConstructor", "generatedConstructor", "implementPlatformSpecificParts", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isKClassArray", "kClassArrayToJClassArray", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "kClassArray", "kClassToJClass", "irExpression", "kClassToJClassIfNeeded", "backend.jvm.lower"})
public final class JvmAnnotationImplementationTransformer
extends AnnotationImplementationTransformer {
    @NotNull
    private final JvmBackendContext jvmContext;
    @NotNull
    private final Set<IrClassSymbol> publicAnnotationImplementationClasses;

    public JvmAnnotationImplementationTransformer(@NotNull JvmBackendContext jvmContext, @NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)jvmContext, (String)"jvmContext");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super((BackendContext)jvmContext, file2);
        this.jvmContext = jvmContext;
        this.publicAnnotationImplementationClasses = new LinkedHashSet();
    }

    @NotNull
    public final JvmBackendContext getJvmContext() {
        return this.jvmContext;
    }

    private final boolean getInInlineFunctionScope() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr it = (ScopeWithIr)element$iv;
                    boolean bl2 = false;
                    IrElement $this$safeAs$iv = it.getIrElement();
                    boolean $i$f$safeAs = false;
                    IrElement irElement = $this$safeAs$iv;
                    if (!(irElement instanceof IrDeclaration)) {
                        irElement = null;
                    }
                    IrDeclaration irDeclaration2 = (IrDeclaration)irElement;
                    boolean bl3 = irDeclaration2 != null ? JvmIrInlineUtilsKt.isInPublicInlineScope(irDeclaration2) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public IrConstructor chooseConstructor(@NotNull IrClass implClass, @NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)implClass));
    }

    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClassSymbol constructedClass = IrTypesKt.getClassOrNull((IrType)expression2.getType());
        IrClassSymbol irClassSymbol = constructedClass;
        boolean bl = irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null ? IrUtilsKt.isAnnotationClass((IrClass)irClassSymbol) : false;
        if (bl && this.getInInlineFunctionScope()) {
            ((Collection)this.publicAnnotationImplementationClasses).add(constructedClass);
        }
        return super.visitConstructorCall(expression2);
    }

    private final IrType kClassToJClassIfNeeded(IrType $this$kClassToJClassIfNeeded) {
        IrType irType;
        if (IrTypePredicatesKt.isKClass((IrType)$this$kClassToJClassIfNeeded)) {
            irType = (IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)this.jvmContext.getIr().getSymbols().getJavaLangClass());
        } else if (this.isKClassArray($this$kClassToJClassIfNeeded)) {
            IrType[] irTypeArray = new IrType[]{(IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)this.jvmContext.getIr().getSymbols().getJavaLangClass())};
            irType = (IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.jvmContext.getIrBuiltIns().getArrayClass()), (IrType[])irTypeArray);
        } else {
            irType = $this$kClassToJClassIfNeeded;
        }
        return irType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassArray(IrType $this$isKClassArray) {
        if (!($this$isKClassArray instanceof IrSimpleType)) return false;
        if (!IrTypePredicatesKt.isArray((IrType)$this$isKClassArray)) return false;
        IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)((IrTypeArgument)CollectionsKt.single((List)((IrSimpleType)$this$isKClassArray).getArguments())));
        if (irType == null) return false;
        if (!IrTypePredicatesKt.isKClass((IrType)irType)) return false;
        return true;
    }

    private final IrExpression kClassToJClass(IrBuilderWithScope $this$kClassToJClass, IrExpression irExpression) {
        IrCall irCall;
        IrType irType = (IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)this.jvmContext.getIr().getSymbols().getJavaLangClass());
        IrSimpleFunction irSimpleFunction = ((IrProperty)this.jvmContext.getIr().getSymbols().getKClassJava().getOwner()).getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrCall $this$kClassToJClass_u24lambda_u2d1 = irCall = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassToJClass, (IrType)irType, null, (IrFunctionSymbol)((IrFunctionSymbol)irSimpleFunction.getSymbol()));
        boolean bl = false;
        $this$kClassToJClass_u24lambda_u2d1.setExtensionReceiver(irExpression);
        return (IrExpression)irCall;
    }

    /*
     * Unable to fully structure code
     */
    private final IrExpression kClassArrayToJClassArray(IrBuilderWithScope $this$kClassArrayToJClassArray, IrExpression kClassArray) {
        block13: {
            javaLangClass = IrTypesKt.getStarProjectedType((IrClassSymbol)this.jvmContext.getIr().getSymbols().getJavaLangClass());
            var5_4 = new IrType[]{(IrType)javaLangClass};
            jlcArray = IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.jvmContext.getIr().getSymbols().getArray()), (IrType[])var5_4);
            arrayClass = (IrClass)this.jvmContext.getIr().getSymbols().getArray().getOwner();
            arrayOfNulls = this.jvmContext.getIr().getSymbols().getArrayOfNulls();
            $this$findDeclaration$iv = (IrDeclarationContainer)arrayClass;
            $i$f$findDeclaration = false;
            for (T var11_12 : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                it$iv = (IrDeclaration)var11_12;
                $i$a$-find-IrUtilsKt$findDeclaration$1$iv = false;
                if (!(it$iv instanceof IrProperty)) ** GOTO lbl-1000
                it = (IrProperty)it$iv;
                $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$arraySizeSymbol$1 = false;
                if (Intrinsics.areEqual((Object)it.getName().asString(), (Object)"size")) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                v1 = var11_12;
                break block13;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrProperty)) {
            v2 = null;
        }
        v3 = (IrDeclaration)((IrProperty)v2);
        Intrinsics.checkNotNull((Object)v3);
        v4 = ((IrProperty)v3).getGetter();
        Intrinsics.checkNotNull((Object)v4);
        arraySizeSymbol = v4;
        $this$irBlock_u24default$iv = $this$kClassArrayToJClassArray;
        startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        origin$iv = null;
        resultType$iv = null;
        $i$f$irBlock = false;
        $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$arraySizeSymbol$1 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        $i$f$block = false;
        $this$kClassArrayToJClassArray_u24lambda_u2d12 = this_$iv$iv;
        $i$a$-irBlock$default-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1 = false;
        sourceArray = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrExpression)kClassArray, (String)"src", (boolean)false, null, null, (int)24, null);
        index = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrExpression)((IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (int)0, null, (int)2, null)), (String)"i", (boolean)true, null, null, (int)24, null);
        var22_28 = var21_27 = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrFunction)((IrFunction)arraySizeSymbol));
        var23_29 = (IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2d12;
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$size$1 = false;
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d3.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrValueDeclaration)((IrValueDeclaration)sourceArray)));
        size = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)var23_29, (IrExpression)((IrExpression)var21_27), (String)"size", (boolean)false, null, null, (int)24, null);
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$size$1 = $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d3 = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrSimpleFunctionSymbol)arrayOfNulls, (IrType)((IrType)jlcArray), (int)0, (int)0, null, (int)28, null);
        var23_29 = (IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2d12;
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$result$1 = false;
        CollectionsKt.listOf((Object)javaLangClass);
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d4.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrValueDeclaration)((IrValueDeclaration)size)));
        result = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)var23_29, (IrExpression)((IrExpression)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d3), null, (boolean)false, null, null, (int)30, null);
        v5 = $this$kClassArrayToJClassArray_u24lambda_u2d12.getStartOffset();
        v6 = $this$kClassArrayToJClassArray_u24lambda_u2d12.getEndOffset();
        v7 = $this$kClassArrayToJClassArray_u24lambda_u2d12.getContext().getIrBuiltIns().getLessFunByOperandType().get(IrTypesKt.getClassifierOrFail((IrType)$this$kClassArrayToJClassArray_u24lambda_u2d12.getContext().getIrBuiltIns().getIntType()));
        Intrinsics.checkNotNull(v7);
        comparison = PrimitivesKt.primitiveOp2((int)v5, (int)v6, (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)v7), (IrType)$this$kClassArrayToJClassArray_u24lambda_u2d12.getContext().getIrBuiltIns().getBooleanType(), (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.LT.INSTANCE), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrValueDeclaration)((IrValueDeclaration)index))), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrValueDeclaration)((IrValueDeclaration)size))));
        $this$single$iv = IrUtilsKt.getFunctions((IrClass)arrayClass);
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrSimpleFunction)element$iv;
            $i$a$-single-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$setArraySymbol$1 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.SET)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        setArraySymbol = single$iv;
        $this$single$iv = IrUtilsKt.getFunctions((IrClass)arrayClass);
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrSimpleFunction)element$iv;
            $i$a$-single-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$getArraySymbol$1 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.GET)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        getArraySymbol = single$iv;
        v8 = IrTypesKt.getClass((IrType)$this$kClassArrayToJClassArray_u24lambda_u2d12.getContext().getIrBuiltIns().getIntType());
        Intrinsics.checkNotNull((Object)v8);
        $this$single$iv = IrUtilsKt.getFunctions((IrClass)v8);
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (E element$iv : $this$single$iv) {
            it = (IrSimpleFunction)element$iv;
            $i$a$-single-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$inc$1 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.INC)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        inc = single$iv;
        $i$f$single = var28_39 = IrBuildersKt.irWhile$default((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), null, (int)1, null);
        var23_29 = $this$kClassArrayToJClassArray_u24lambda_u2d12;
        $i$a$-also-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1 = false;
        loop.setCondition(comparison);
        $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12;
        startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        origin$iv = null;
        resultType$iv = null;
        $i$f$irBlock = false;
        var37_63 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        $i$f$block = false;
        var39_65 = this_$iv$iv;
        var40_66 = loop;
        $i$a$-irBlock$default-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1$1 = false;
        tempIndex = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueDeclaration)((IrValueDeclaration)index))), null, (boolean)false, null, null, (int)30, null);
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8 = var43_69 = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrFunction)((IrFunction)getArraySymbol));
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1$1$getArray$1 = false;
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueDeclaration)((IrValueDeclaration)sourceArray)));
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueDeclaration)((IrValueDeclaration)tempIndex)));
        getArray = var43_69;
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8 = var43_69 = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrFunction)((IrFunction)setArraySymbol));
        var47_73 = $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10;
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1$1$1 = false;
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueDeclaration)((IrValueDeclaration)result)));
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueDeclaration)((IrValueDeclaration)tempIndex)));
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.putValueArgument(1, this.kClassToJClass((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10, (IrExpression)getArray));
        var47_73.unaryPlus((IrStatement)var43_69);
        $this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10.unaryPlus((IrStatement)ExpressionHelpersKt.irSet$default((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueSymbol)((IrValueSymbol)index.getSymbol()), (IrExpression)((IrExpression)ExpressionHelpersKt.irCallOp$default((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrSimpleFunctionSymbol)inc.getSymbol(), (IrType)index.getType(), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10), (IrValueDeclaration)((IrValueDeclaration)index))), null, null, (int)24, null)), null, (int)4, null));
        var40_66.setBody((IrExpression)this_$iv$iv.doBuild());
        var23_29.unaryPlus((IrStatement)var28_39);
        $this$kClassArrayToJClassArray_u24lambda_u2d12.unaryPlus((IrStatement)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2d12), (IrValueDeclaration)((IrValueDeclaration)result)));
        block = this_$iv$iv.doBuild();
        return (IrExpression)block;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public IrFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            targetType = IrTypeUtilsKt.isPrimitiveArray((IrType)type) != false ? type : (IrType)this.jvmContext.getIr().getSymbols().getArrayOfAnyNType();
            $this$findDeclaration$iv = (IrDeclarationContainer)this.jvmContext.getIr().getSymbols().getArraysClass().getOwner();
            $i$f$findDeclaration = false;
            for (T var7_8 : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                it$iv = (IrDeclaration)var7_8;
                $i$a$-find-IrUtilsKt$findDeclaration$1$iv = false;
                if (!(it$iv instanceof IrFunction)) ** GOTO lbl-1000
                it = (IrFunction)it$iv;
                $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$getArrayContentEqualsSymbol$requiredSymbol$1 = false;
                if (Intrinsics.areEqual((Object)it.getName().asString(), (Object)"equals") != false && it.getValueParameters().size() == 2 && Intrinsics.areEqual((Object)((IrValueParameter)CollectionsKt.first((List)it.getValueParameters())).getType(), (Object)targetType) != false) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                v1 = var7_8;
                break block5;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrFunction)) {
            v2 = null;
        }
        if ((requiredSymbol = (IrFunction)((IrDeclaration)((IrFunction)v2))) == null) {
            $i$a$-requireNotNull-JvmAnnotationImplementationTransformer$getArrayContentEqualsSymbol$1 = false;
            var4_5 = "Can't find Arrays.equals method for type " + RenderIrElementKt.render((IrType)targetType);
            throw new IllegalArgumentException(var4_5.toString());
        }
        return requiredSymbol.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        void this_$iv$iv;
        void $this$implementPlatformSpecificParts_u24lambda_u2d17_u24lambda_u2d16;
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        if (this.publicAnnotationImplementationClasses.contains(annotationClass.getSymbol())) {
            ((Collection)this.jvmContext.getPublicAbiSymbols()).add(implClass.getSymbol());
        }
        IrSimpleType irSimpleType = IrTypesKt.getStarProjectedType((IrClassSymbol)this.jvmContext.getIr().getSymbols().getJavaLangClass());
        IrDeclarationOriginImpl irDeclarationOriginImpl = AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION();
        IrSimpleType $this$implementPlatformSpecificParts_u24lambda_u2d17 = irSimpleType = DeclarationBuildersKt.addFunction$default((IrClass)implClass, (String)"annotationType", (IrType)((IrType)irSimpleType), null, null, (boolean)false, (boolean)false, (boolean)false, (IrDeclarationOrigin)((IrDeclarationOrigin)irDeclarationOriginImpl), (int)0, (int)0, (int)876, null);
        boolean bl = false;
        JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(this.jvmContext, (IrSymbol)$this$implementPlatformSpecificParts_u24lambda_u2d17.getSymbol(), 0, 0, 6, null);
        IrSimpleType irSimpleType2 = $this$implementPlatformSpecificParts_u24lambda_u2d17;
        boolean bl2 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$implementPlatformSpecificParts_u24lambda_u2d17_u24lambda_u2d16;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$implementPlatformSpecificParts_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15 = this_$iv$iv;
        boolean bl3 = false;
        $this$implementPlatformSpecificParts_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$implementPlatformSpecificParts_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15), (IrExpression)((IrExpression)JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$implementPlatformSpecificParts_u24lambda_u2d17_u24lambda_u2d16, (IrType)IrUtilsKt.getDefaultType((IrClass)annotationClass)))));
        irSimpleType2.setBody((IrBody)this_$iv$iv.doBuild());
    }

    /*
     * WARNING - void declaration
     */
    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)generatedConstructor, (String)"generatedConstructor");
        DeclarationIrBuilder ctorBodyBuilder = LowerUtilsKt.createIrBuilder((BackendContext)this.getContext(), (IrSymbol)((IrSymbol)generatedConstructor.getSymbol()), (int)-2, (int)-2);
        IrBlockBody ctorBody = this.getContext().getIrFactory().createBlockBody(-2, -2, CollectionsKt.listOf((Object)new IrDelegatingConstructorCallImpl(-2, -2, this.getContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)this.getContext().getIrBuiltIns().getAnyClass())), 0, 0)));
        generatedConstructor.setBody((IrBody)ctorBody);
        Iterable $this$forEach$iv = this.getAnnotationProperties(annotationClass);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25;
            void this_$iv$iv;
            IrPropertyBuilder irPropertyBuilder;
            IrClass prop;
            IrFieldBuilder irFieldBuilder;
            IrExpressionBody irExpressionBody;
            IrExpression defaultExpression;
            IrProperty property = (IrProperty)element$iv;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = property.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            IrType propType = irSimpleFunction.getReturnType();
            IrType storedFieldType = this.kClassToJClassIfNeeded(propType);
            Name propName = property.getName();
            IrFactory $this$buildField$iv = this.getContext().getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = new IrFieldBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = false;
            IrFieldBuilder $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18 = $this$buildField_u24lambda_u2d4$iv;
            boolean bl22 = false;
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setStartOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setEndOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setName(propName);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setType(storedFieldType);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setOrigin((IrDeclarationOrigin)AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setFinal(true);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18.setVisibility(descriptorVisibility);
            IrFactory it = $this$buildField$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u2d4$iv);
            boolean bl3 = false;
            it.setParent((IrDeclarationParent)implClass);
            IrFactory field = $this$buildField$iv;
            IrFunction irFunction = (IrFunction)generatedConstructor;
            String string2 = propName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"propName.asString()");
            IrValueParameter parameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)irFunction, (String)string2, (IrType)propType, null, (int)4, null);
            IrField irField = property.getBackingField();
            IrExpression irExpression = irField != null && (irField = irField.getInitializer()) != null ? irField.getExpression() : (defaultExpression = null);
            if (defaultExpression instanceof IrGetValue && ((IrGetValue)defaultExpression).getSymbol().getOwner() instanceof IrValueParameter) {
                IrValueDeclaration irValueDeclaration = ((IrGetValue)defaultExpression).getSymbol().getOwner();
                Intrinsics.checkNotNull((Object)irValueDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrValueParameter");
                irExpressionBody = ((IrValueParameter)irValueDeclaration).getDefaultValue();
            } else if (defaultExpression != null) {
                IrField irField2 = property.getBackingField();
                Intrinsics.checkNotNull((Object)irField2);
                irExpressionBody = irField2.getInitializer();
            } else {
                irExpressionBody = null;
            }
            IrExpressionBody newDefaultValue = irExpressionBody;
            IrValueParameter irValueParameter = parameter;
            IrExpressionBody irExpressionBody2 = newDefaultValue;
            if (irExpressionBody2 != null && (irExpressionBody2 = (IrExpressionBody)DeepCopyIrTreeWithDeclarationsKt.deepCopyWithVariables((IrElement)((IrElement)irExpressionBody2))) != null) {
                void it2;
                IrFieldBuilder bl22 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18 = irExpressionBody2;
                IrValueParameter irValueParameter2 = irValueParameter;
                boolean bl4 = false;
                this.transformChildrenVoid((IrElement)it2);
                irValueParameter = irValueParameter2;
                irFieldBuilder = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d18;
            } else {
                irFieldBuilder = null;
            }
            irValueParameter.setDefaultValue(irFieldBuilder);
            Collection $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = ctorBody.getStatements();
            DeclarationIrBuilder $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21 = ctorBodyBuilder;
            boolean bl5 = false;
            IrGetValueImpl param = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21), (IrValueDeclaration)((IrValueDeclaration)parameter));
            IrExpression fieldValue = IrTypePredicatesKt.isKClass((IrType)propType) ? this.kClassToJClass((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21, (IrExpression)param) : (this.isKClassArray(propType) ? this.kClassArrayToJClassArray((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21, (IrExpression)param) : (IrExpression)param);
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21;
            IrValueParameter irValueParameter3 = implClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter3);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21 = ExpressionHelpersKt.irSetField$default((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter3))), (IrField)field, (IrExpression)fieldValue, null, (int)8, null);
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv22.add($this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d21);
            IrClass $this$addProperty$iv = implClass;
            boolean $i$f$addProperty = false;
            IrFactory $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            IrPropertyBuilder $this$buildProperty_u24lambda_u2d8$iv$iv = new IrPropertyBuilder();
            boolean bl6 = false;
            IrPropertyBuilder $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22 = $this$buildProperty_u24lambda_u2d8$iv$iv;
            boolean bl7 = false;
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22.setStartOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22.setEndOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22.setName(propName);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22.setVar(false);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22.setOrigin((IrDeclarationOrigin)AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            IrFactory property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, (IrPropertyBuilder)$this$buildProperty_u24lambda_u2d8$iv$iv);
            boolean bl8 = false;
            $this$addProperty$iv.getDeclarations().add(property$iv);
            property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
            IrClass $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d23 = $this$addProperty$iv = $this$buildProperty$iv$iv;
            boolean bl9 = false;
            field.setCorrespondingPropertySymbol($this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d23.getSymbol());
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d23.setBackingField((IrField)field);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d23.setParent((IrDeclarationParent)implClass);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d23.setOverriddenSymbols(CollectionsKt.listOf((Object)property.getSymbol()));
            IrClass $this$addGetter$iv = prop = $this$addProperty$iv;
            boolean $i$f$addGetter = false;
            IrFunctionBuilder $this$addGetter_u24lambda_u2d11$iv = new IrFunctionBuilder();
            boolean bl10 = false;
            Name name = Name.special((String)("<get-" + $this$addGetter$iv.getName() + '>'));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<get-${this@addGetter.name}>\")");
            $this$addGetter_u24lambda_u2d11$iv.setName(name);
            IrFunctionBuilder $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24 = $this$addGetter_u24lambda_u2d11$iv;
            boolean bl11 = false;
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setStartOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setEndOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setName(propName);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setReturnType(this.kClassToJClassIfNeeded(propType));
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setOrigin((IrDeclarationOrigin)AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setVisibility(descriptorVisibility2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d24.setModality(Modality.FINAL);
            IrPropertyBuilder getter$iv = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22 = DeclarationBuildersKt.buildFunction((IrFactory)$this$addGetter$iv.getFactory(), (IrFunctionBuilder)$this$addGetter_u24lambda_u2d11$iv);
            boolean bl12 = false;
            $this$addGetter$iv.setGetter((IrSimpleFunction)getter$iv);
            getter$iv.setCorrespondingPropertySymbol($this$addGetter$iv.getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            IrPropertyBuilder $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26 = irPropertyBuilder = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d22;
            boolean bl13 = false;
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26.setCorrespondingPropertySymbol(prop.getSymbol());
            IrValueParameter irValueParameter4 = implClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter4);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26.setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter4, (IrFunction)((IrFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26), null, (int)0, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8190, null));
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder((BackendContext)this.getContext(), (IrSymbol)((IrSymbol)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26.getSymbol()), (int)-2, (int)-2);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            getter$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void var30_49 = this_$iv$iv;
            IrPropertyBuilder irPropertyBuilder2 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26;
            boolean bl14 = false;
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25;
            IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25;
            IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25;
            IrValueParameter irValueParameter5 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter5);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope3, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)irBuilderWithScope4, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope5, (IrValueDeclaration)((IrValueDeclaration)irValueParameter5))), (IrField)field))));
            irPropertyBuilder2.setBody((IrBody)this_$iv$iv.doBuild());
            IrSimpleFunction irSimpleFunction2 = property.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2d27_u24lambda_u2d26.setOverriddenSymbols(CollectionsKt.listOf((Object)irSimpleFunction2.getSymbol()));
        }
    }

    public void generateFunctionBodies(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull IrSimpleFunction eqFun, @NotNull IrSimpleFunction hcFun, @NotNull IrSimpleFunction toStringFun, @NotNull AnnotationImplementationMemberGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)eqFun, (String)"eqFun");
        Intrinsics.checkNotNullParameter((Object)hcFun, (String)"hcFun");
        Intrinsics.checkNotNullParameter((Object)toStringFun, (String)"toStringFun");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        List properties2 = this.getAnnotationProperties(annotationClass);
        List implProperties = this.getAnnotationProperties(implClass);
        generator.generateEqualsUsingGetters(eqFun, (IrType)IrUtilsKt.getDefaultType((IrClass)annotationClass), properties2);
        generator.generateHashCodeMethod((IrFunction)hcFun, implProperties);
        generator.generateToStringMethod((IrFunction)toStringFun, implProperties);
    }
}

