/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import org.apache.ivy.plugins.repository.ssh.RemoteScpException;
import org.apache.ivy.plugins.repository.ssh.Scp;
import org.apache.ivy.plugins.repository.ssh.SshResource;
import org.apache.ivy.util.Message;

public class SshRepository
extends AbstractSshBasedRepository {
    private static final int BUFFER_SIZE = 65536;
    private static final String ARGUMENT_PLACEHOLDER = "%arg";
    private static final int POLL_SLEEP_TIME = 500;
    private char fileSeparator = (char)47;
    private String listCommand = "ls -1";
    private String existCommand = "ls";
    private String createDirCommand = "mkdir";
    private String publishPermissions = null;

    public SshRepository() {
    }

    public SshRepository(TimeoutConstraint timeoutConstraint) {
        super(timeoutConstraint);
    }

    @Override
    public Resource getResource(String source) {
        Message.debug("SShRepository:getResource called: " + source);
        return new SshResource(this, source);
    }

    public SshResource resolveResource(String source) {
        Message.debug("SShRepository:resolveResource called: " + source);
        SshResource result2 = null;
        Session session = null;
        try {
            session = this.getSession(source);
            Scp myCopy = new Scp(session);
            Scp.FileInfo fileInfo = myCopy.getFileinfo(new URI(source).getPath());
            result2 = new SshResource(this, source, true, fileInfo.getLength(), fileInfo.getLastModified());
        }
        catch (IOException | URISyntaxException e) {
            if (session != null) {
                this.releaseSession(session, source);
            }
            result2 = new SshResource();
        }
        catch (RemoteScpException e) {
            result2 = new SshResource();
        }
        Message.debug("SShRepository:resolveResource end.");
        return result2;
    }

    private void readSessionOutput(ChannelExec channel2, StringBuilder strStdout, StringBuilder strStderr) throws IOException {
        int len;
        int avail;
        InputStream stdout = channel2.getInputStream();
        InputStream stderr = channel2.getErrStream();
        try {
            channel2.connect();
        }
        catch (JSchException jsche) {
            throw new IOException("Channel connection problems", jsche);
        }
        byte[] buffer2 = new byte[65536];
        while (true) {
            avail = 0;
            while ((avail = stdout.available()) > 0) {
                len = stdout.read(buffer2, 0, avail > 65535 ? 65536 : avail);
                strStdout.append(new String(buffer2, 0, len));
            }
            while ((avail = stderr.available()) > 0) {
                len = stderr.read(buffer2, 0, avail > 65535 ? 65536 : avail);
                strStderr.append(new String(buffer2, 0, len));
            }
            if (channel2.isClosed()) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception len2) {}
        }
        avail = 0;
        while ((avail = stdout.available()) > 0) {
            len = stdout.read(buffer2, 0, avail > 65535 ? 65536 : avail);
            strStdout.append(new String(buffer2, 0, len));
        }
        while ((avail = stderr.available()) > 0) {
            len = stderr.read(buffer2, 0, avail > 65535 ? 65536 : avail);
            strStderr.append(new String(buffer2, 0, len));
        }
    }

    @Override
    public List<String> list(String parent) throws IOException {
        Message.debug("SShRepository:list called: " + parent);
        ArrayList<String> result2 = new ArrayList<String>();
        Session session = null;
        ChannelExec channel2 = null;
        session = this.getSession(parent);
        channel2 = this.getExecChannel(session);
        URI parentUri = null;
        try {
            parentUri = new URI(parent);
        }
        catch (URISyntaxException e) {
            throw new IOException("The uri '" + parent + "' is not valid!", e);
        }
        String fullCmd = this.replaceArgument(this.listCommand, parentUri.getPath());
        channel2.setCommand(fullCmd);
        StringBuilder stdOut = new StringBuilder();
        StringBuilder stdErr = new StringBuilder();
        this.readSessionOutput(channel2, stdOut, stdErr);
        if (channel2.getExitStatus() != 0) {
            Message.error("Ssh ListCommand exited with status != 0");
            Message.error(stdErr.toString());
            return null;
        }
        BufferedReader br = new BufferedReader(new StringReader(stdOut.toString()));
        String line2 = null;
        while ((line2 = br.readLine()) != null) {
            result2.add(line2);
        }
        return result2;
    }

    private ChannelExec getExecChannel(Session session) throws IOException {
        ChannelExec channel2;
        try {
            channel2 = (ChannelExec)session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new IOException();
        }
        return channel2;
    }

    private String replaceArgument(String command, String argument) {
        String fullCmd = !command.contains(ARGUMENT_PLACEHOLDER) ? command + " " + argument : command.replaceAll(ARGUMENT_PLACEHOLDER, argument);
        return fullCmd;
    }

    @Override
    public void put(File source, String destination, boolean overwrite) throws IOException {
        Message.debug("SShRepository:put called: " + destination);
        Session session = this.getSession(destination);
        URI destinationUri = null;
        try {
            destinationUri = new URI(destination);
        }
        catch (URISyntaxException e) {
            throw new IOException("The uri '" + destination + "' is not valid!", e);
        }
        try {
            String path2;
            String name2;
            String filePath = destinationUri.getPath();
            int lastSep = filePath.lastIndexOf(this.fileSeparator);
            if (lastSep == -1) {
                name2 = filePath;
                path2 = null;
            } else {
                name2 = filePath.substring(lastSep + 1);
                path2 = filePath.substring(0, lastSep);
            }
            if (!overwrite && this.checkExistence(filePath, session)) {
                throw new IOException("destination file exists and overwrite == false");
            }
            if (path2 != null) {
                this.makePath(path2, session);
            }
            Scp myCopy = new Scp(session);
            myCopy.put(source.getCanonicalPath(), path2, name2, this.publishPermissions);
        }
        catch (IOException e) {
            if (session != null) {
                this.releaseSession(session, destination);
            }
            throw e;
        }
        catch (RemoteScpException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePath(String path2, Session session) throws IOException {
        ChannelExec channel2 = null;
        String trimmed = path2;
        try {
            while (trimmed.length() > 0 && trimmed.charAt(trimmed.length() - 1) == this.fileSeparator) {
                trimmed = trimmed.substring(0, trimmed.length() - 1);
            }
            if (trimmed.length() == 0 || this.checkExistence(trimmed, session)) {
                return;
            }
            int nextSlash = trimmed.lastIndexOf(this.fileSeparator);
            if (nextSlash > 0) {
                String parent = trimmed.substring(0, nextSlash);
                this.makePath(parent, session);
            }
            channel2 = this.getExecChannel(session);
            String mkdir = this.replaceArgument(this.createDirCommand, trimmed);
            Message.debug("SShRepository: trying to create path: " + mkdir);
            channel2.setCommand(mkdir);
            StringBuilder stdOut = new StringBuilder();
            StringBuilder stdErr = new StringBuilder();
            this.readSessionOutput(channel2, stdOut, stdErr);
        }
        finally {
            if (channel2 != null) {
                channel2.disconnect();
            }
        }
    }

    private boolean checkExistence(String filePath, Session session) throws IOException {
        Message.debug("SShRepository: checkExistence called: " + filePath);
        ChannelExec channel2 = null;
        channel2 = this.getExecChannel(session);
        String fullCmd = this.replaceArgument(this.existCommand, filePath);
        channel2.setCommand(fullCmd);
        StringBuilder stdOut = new StringBuilder();
        StringBuilder stdErr = new StringBuilder();
        this.readSessionOutput(channel2, stdOut, stdErr);
        return channel2.getExitStatus() == 0;
    }

    @Override
    public void get(String source, File destination) throws IOException {
        Message.debug("SShRepository:get called: " + source + " to " + destination.getCanonicalPath());
        if (destination.getParentFile() != null) {
            destination.getParentFile().mkdirs();
        }
        Session session = this.getSession(source);
        URI sourceUri = null;
        try {
            sourceUri = new URI(source);
        }
        catch (URISyntaxException e) {
            throw new IOException("The uri '" + source + "' is not valid!", e);
        }
        try {
            Scp myCopy = new Scp(session);
            myCopy.get(sourceUri.getPath(), destination.getCanonicalPath());
        }
        catch (IOException e) {
            if (session != null) {
                this.releaseSession(session, source);
            }
            throw e;
        }
        catch (RemoteScpException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setListCommand(String cmd) {
        this.listCommand = cmd.trim();
    }

    public String getListCommand() {
        return this.listCommand;
    }

    public String getCreateDirCommand() {
        return this.createDirCommand;
    }

    public void setCreateDirCommand(String createDirCommand) {
        this.createDirCommand = createDirCommand;
    }

    public String getExistCommand() {
        return this.existCommand;
    }

    public void setExistCommand(String existCommand) {
        this.existCommand = existCommand;
    }

    public void setFileSeparator(char fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public void setPublishPermissions(String permissions2) {
        this.publishPermissions = permissions2;
    }

    @Override
    protected String getRepositoryScheme() {
        return "ssh";
    }

    public InputStream openStream(SshResource resource) throws IOException {
        Session session = this.getSession(resource.getName());
        Scp scp = new Scp(session);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            scp.get(resource.getName(), os);
        }
        catch (IOException e) {
            if (session != null) {
                this.releaseSession(session, resource.getName());
            }
            throw e;
        }
        catch (RemoteScpException e) {
            throw new IOException(e.getMessage());
        }
        return new ByteArrayInputStream(os.toByteArray());
    }
}

