/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.promo;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.space.SpaceIcons;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.promo.ImageLoader;
import com.intellij.space.promo.JComponentOverlay;
import com.intellij.space.promo.PromoKt;
import com.intellij.space.promo.PromoKt$WhenMappings;
import com.intellij.space.promo.SpaceExplorePlace;
import com.intellij.space.promo.SpaceOverviewPlace;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.layout.RowKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.FontUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0007\u001a\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0007\u001a\b\u0010\u0019\u001a\u00020\u0014H\u0007\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0007\u001a\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u0017H\u0007\u001a\n\u0010%\u001a\u0004\u0018\u00010\u0014H\u0007\u001a\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u001a,\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020+H\u0007\u001a\u0014\u0010-\u001a\u00020'*\u00020.2\u0006\u0010\u001c\u001a\u00020\fH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u0001*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"DARK_POSTFIX", "", "HIDPI_POSTFIX", "JETBRAINS_SPACE_LOGO", "JETBRAINS_SPACE_LOGO_DARK", "SIGN_UP_SPACE_URL", "getSIGN_UP_SPACE_URL", "()Ljava/lang/String;", "SPACE_BIG_PROMO_BANNER_NAME", "SPACE_TOOLBAR_PROMO_BANNER_PATH", "SPACE_TOOLBAR_PROMO_BANNER_PATH_RETINA", "exploreUrl", "Lcom/intellij/space/promo/SpaceExplorePlace;", "getExploreUrl", "(Lcom/intellij/space/promo/SpaceExplorePlace;)Ljava/lang/String;", "overviewUrl", "Lcom/intellij/space/promo/SpaceOverviewPlace;", "getOverviewUrl", "(Lcom/intellij/space/promo/SpaceOverviewPlace;)Ljava/lang/String;", "bigPromoBanner", "Ljavax/swing/JComponent;", "overviewPlace", "width", "", "height", "createSpaceByJetbrainsLabel", "exploreSpaceLink", "Lcom/intellij/ui/components/BrowserLink;", "explorePlace", "getIdePromoUtmParameter", "loadSvg", "Lcom/intellij/util/ui/JBImageIcon;", "path", "comp", "promoText", "Ljavax/swing/JLabel;", "maxLineLength", "toolbarPromoBanner", "watchPromoVideo", "", "wrapWithWatchSpaceOverviewLabelOverlay", "component", "alwaysDisplayLabel", "", "useDarkLabel", "promoPanel", "Lcom/intellij/ui/layout/LayoutBuilder;", "intellij.space"})
public final class PromoKt {
    @NotNull
    public static final String SPACE_TOOLBAR_PROMO_BANNER_PATH = "/images/spacePromo.png";
    @NotNull
    public static final String SPACE_TOOLBAR_PROMO_BANNER_PATH_RETINA = "/images/spacePromo@2x.png";
    @NotNull
    public static final String SPACE_BIG_PROMO_BANNER_NAME = "/images/spaceVideoPreview";
    @NotNull
    public static final String DARK_POSTFIX = "_dark";
    @NotNull
    public static final String HIDPI_POSTFIX = "@2x";
    @NotNull
    public static final String JETBRAINS_SPACE_LOGO = "/images/jetbrainsSpace.svg";
    @NotNull
    public static final String JETBRAINS_SPACE_LOGO_DARK = "/images/jetbrainsSpaceDark.svg";

    @NotNull
    public static final String getSIGN_UP_SPACE_URL() {
        return "https://www.jetbrains.com/space/?utm_source=product&utm_medium=link&" + PromoKt.getIdePromoUtmParameter() + "&utm_content=13362-space&utm_term=main_signup#sign-up";
    }

    @ApiStatus.Internal
    public static final void promoPanel(@NotNull LayoutBuilder $this$promoPanel, @NotNull SpaceExplorePlace explorePlace) {
        Intrinsics.checkNotNullParameter((Object)$this$promoPanel, (String)"$this$promoPanel");
        Intrinsics.checkNotNullParameter((Object)((Object)explorePlace), (String)"explorePlace");
        RowKt.fullRow((RowBuilder)((RowBuilder)$this$promoPanel), (Function1)promoPanel.1.INSTANCE);
        RowKt.fullRow((RowBuilder)((RowBuilder)$this$promoPanel), (Function1)promoPanel.2.INSTANCE);
        RowKt.fullRow((RowBuilder)((RowBuilder)$this$promoPanel), (Function1)((Function1)new Function1<InnerCell, Unit>(explorePlace){
            final /* synthetic */ SpaceExplorePlace $explorePlace;

            public final void invoke(@NotNull InnerCell $this$fullRow) {
                Intrinsics.checkNotNullParameter((Object)$this$fullRow, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$fullRow), (JComponent)((JComponent)PromoKt.exploreSpaceLink(this.$explorePlace)), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
            {
                this.$explorePlace = spaceExplorePlace;
                super(1);
            }
        })).largeGapAfter();
    }

    @ApiStatus.Internal
    @Nullable
    public static final JComponent toolbarPromoBanner() {
        String imagePath = StartupUiUtil.isJreHiDPI() ? SPACE_TOOLBAR_PROMO_BANNER_PATH_RETINA : SPACE_TOOLBAR_PROMO_BANNER_PATH;
        Image image = ImageLoader.INSTANCE.loadImage(imagePath, 364, 200);
        if (image == null) {
            return null;
        }
        Image image2 = image;
        return PromoKt.wrapWithWatchSpaceOverviewLabelOverlay$default(new JLabel((Icon)new JBImageIcon(image2)), SpaceOverviewPlace.MAIN_TOOLBAR, false, false, 12, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static final JComponent bigPromoBanner(@NotNull SpaceOverviewPlace overviewPlace) {
        Intrinsics.checkNotNullParameter((Object)((Object)overviewPlace), (String)"overviewPlace");
        return PromoKt.bigPromoBanner(500, 285, overviewPlace);
    }

    @ApiStatus.Internal
    @Nullable
    public static final JComponent bigPromoBanner(int width, int height, @NotNull SpaceOverviewPlace overviewPlace) {
        Intrinsics.checkNotNullParameter((Object)((Object)overviewPlace), (String)"overviewPlace");
        boolean isDarcula = StartupUiUtil.isUnderDarcula();
        String themePart = isDarcula ? DARK_POSTFIX : "";
        String retinaPart = StartupUiUtil.isJreHiDPI() ? HIDPI_POSTFIX : "";
        String imagePath = SPACE_BIG_PROMO_BANNER_NAME + retinaPart + themePart + ".png";
        Image image = ImageLoader.INSTANCE.loadImage(imagePath, width, height);
        if (image == null) {
            return null;
        }
        Image image2 = image;
        return PromoKt.wrapWithWatchSpaceOverviewLabelOverlay(new JLabel((Icon)new JBImageIcon(image2)), overviewPlace, true, isDarcula);
    }

    @ApiStatus.Internal
    @NotNull
    public static final BrowserLink exploreSpaceLink(@NotNull SpaceExplorePlace explorePlace) {
        BrowserLink browserLink2;
        Intrinsics.checkNotNullParameter((Object)((Object)explorePlace), (String)"explorePlace");
        String string2 = SpaceBundle.message("space.promo.explore.space.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"spa\u2026mo.explore.space.button\")");
        BrowserLink $this$apply = browserLink2 = new BrowserLink(string2, PromoKt.getExploreUrl(explorePlace));
        boolean bl = false;
        $this$apply.addActionListener(new ActionListener(explorePlace){
            final /* synthetic */ SpaceExplorePlace $explorePlace$inlined;
            {
                this.$explorePlace$inlined = spaceExplorePlace;
            }

            public final void actionPerformed(ActionEvent it) {
                SpaceStatsCounterCollector.EXPLORE_SPACE.log((Object)((Object)this.$explorePlace$inlined));
            }
        });
        $this$apply.setFocusPainted(false);
        return browserLink2;
    }

    @ApiStatus.Internal
    @NotNull
    public static final JComponent wrapWithWatchSpaceOverviewLabelOverlay(@NotNull JComponent component2, @NotNull SpaceOverviewPlace overviewPlace, boolean alwaysDisplayLabel, boolean useDarkLabel) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)overviewPlace), (String)"overviewPlace");
        String text2 = "\u25b6" + FontUtil.spaceAndThinSpace() + SpaceBundle.message("space.promo.watch.space.overview.label", new Object[0]);
        Color labelBackground = useDarkLabel ? new Color(0, 0, 0, 180) : new Color(255, 255, 255, 180);
        Color labelForeground = useDarkLabel ? Color.WHITE : Color.BLACK;
        JLabel $this$apply = jComponent = new JLabel(text2);
        boolean bl = false;
        $this$apply.setFocusable(false);
        $this$apply.setOpaque(true);
        $this$apply.setVisible(alwaysDisplayLabel);
        $this$apply.setBackground(labelBackground);
        $this$apply.setForeground(labelForeground);
        $this$apply.setBorder(JBUI.Borders.empty((int)8));
        JLabel watchVideoButton = jComponent;
        $this$apply = jComponent = JComponentOverlay.INSTANCE.createCentered(component2, watchVideoButton);
        boolean bl2 = false;
        $this$apply.setCursor(Cursor.getPredefinedCursor(12));
        $this$apply.addMouseListener(new MouseAdapter(alwaysDisplayLabel, watchVideoButton, overviewPlace){
            final /* synthetic */ boolean $alwaysDisplayLabel$inlined;
            final /* synthetic */ JLabel $watchVideoButton$inlined;
            final /* synthetic */ SpaceOverviewPlace $overviewPlace$inlined;
            {
                this.$alwaysDisplayLabel$inlined = bl;
                this.$watchVideoButton$inlined = jLabel;
                this.$overviewPlace$inlined = spaceOverviewPlace;
            }

            public void mouseEntered(@Nullable MouseEvent e) {
                if (!this.$alwaysDisplayLabel$inlined) {
                    this.$watchVideoButton$inlined.setVisible(true);
                }
            }

            public void mouseExited(@Nullable MouseEvent e) {
                if (!this.$alwaysDisplayLabel$inlined) {
                    this.$watchVideoButton$inlined.setVisible(false);
                }
            }

            public void mouseClicked(@Nullable MouseEvent e) {
                SpaceStatsCounterCollector.WATCH_OVERVIEW.log((Object)((Object)this.$overviewPlace$inlined));
                PromoKt.access$watchPromoVideo(this.$overviewPlace$inlined);
            }
        });
        return jComponent;
    }

    public static /* synthetic */ JComponent wrapWithWatchSpaceOverviewLabelOverlay$default(JComponent jComponent, SpaceOverviewPlace spaceOverviewPlace, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return PromoKt.wrapWithWatchSpaceOverviewLabelOverlay(jComponent, spaceOverviewPlace, bl, bl2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final JComponent createSpaceByJetbrainsLabel() {
        JLabel jLabel;
        JLabel $this$apply = jLabel = new JLabel();
        boolean bl = false;
        JBImageIcon jbSpaceSvgLogo = PromoKt.loadSvg(StartupUiUtil.isUnderDarcula() ? JETBRAINS_SPACE_LOGO_DARK : JETBRAINS_SPACE_LOGO, $this$apply);
        if (jbSpaceSvgLogo != null) {
            $this$apply.setIcon((Icon)jbSpaceSvgLogo);
        } else {
            $this$apply.setIcon(SpaceIcons.Main);
            $this$apply.setText(SpaceBundle.message("product.name.jetbrains.space", new Object[0]));
        }
        return jLabel;
    }

    @ApiStatus.Internal
    @NotNull
    public static final JLabel promoText(int maxLineLength) {
        JLabel jLabel;
        JLabel jLabel2 = ComponentPanelBuilder.createCommentComponent((String)SpaceBundle.message("space.promo.text.full", new Object[0]), (boolean)true, (int)maxLineLength);
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"ComponentPanelBuilder.cr\u2026l\"), true, maxLineLength)");
        JLabel $this$apply = jLabel = jLabel2;
        boolean bl = false;
        $this$apply.setForeground(JBUI.CurrentTheme.Label.foreground());
        $this$apply.setFont((Font)JBUI.Fonts.label());
        return jLabel;
    }

    public static /* synthetic */ JLabel promoText$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return PromoKt.promoText(n);
    }

    private static final void watchPromoVideo(SpaceOverviewPlace overviewPlace) {
        BrowserUtil.browse((String)PromoKt.getOverviewUrl(overviewPlace));
    }

    /*
     * WARNING - void declaration
     */
    private static final JBImageIcon loadSvg(String path2, JComponent comp) {
        JBImageIcon jBImageIcon;
        try {
            InputStream inputStream = ImageLoader.class.getResourceAsStream(path2);
            Intrinsics.checkNotNull((Object)inputStream);
            byte[] bytes = inputStream.readAllBytes();
            ScaleContext scaleContext = ScaleContext.create((Component)comp);
            Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"ScaleContext.create(comp)");
            ScaleContext ctx = scaleContext;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            BufferedImage image = SVGLoader.loadWithoutCache((byte[])bytes, (float)((float)ctx.getScale(ScaleType.SYS_SCALE)));
            Image hiDpi = ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ctx);
            jBImageIcon = new JBImageIcon(hiDpi);
        }
        catch (Exception e) {
            void this_$iv;
            boolean $i$f$logger22 = false;
            KLogger $i$f$logger22 = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ImageLoader.class));
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                void var7_10 = this_$iv;
                boolean bl = false;
                String string2 = "Svg " + path2 + " is not loaded";
                var7_10.error(string2);
            }
            jBImageIcon = null;
        }
        return jBImageIcon;
    }

    @NotNull
    public static final String getOverviewUrl(@NotNull SpaceOverviewPlace $this$overviewUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$overviewUrl), (String)"$this$overviewUrl");
        switch (PromoKt$WhenMappings.$EnumSwitchMapping$0[$this$overviewUrl.ordinal()]) {
            case 1: {
                string2 = "main_toolbar-overview";
                break;
            }
            case 2: {
                string2 = "main_ide-settings-overview";
                break;
            }
            case 3: {
                string2 = "main_clone-repo-overview";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String placeUtm = string2;
        return "https://www.jetbrains.com/space/?show-overview=from-ide&utm_source=product&utm_medium=link&" + PromoKt.getIdePromoUtmParameter() + "&utm_content=13362-space&utm_term=" + placeUtm;
    }

    @NotNull
    public static final String getExploreUrl(@NotNull SpaceExplorePlace $this$exploreUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$exploreUrl), (String)"$this$exploreUrl");
        switch (PromoKt$WhenMappings.$EnumSwitchMapping$1[$this$exploreUrl.ordinal()]) {
            case 1: {
                string2 = "main_toolbar-explore";
                break;
            }
            case 2: {
                string2 = "main_ide-settings-explore";
                break;
            }
            case 3: {
                string2 = "main_share-proj-explore";
                break;
            }
            case 4: {
                string2 = "main_clone-repo-explore";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String placeUtm = string2;
        return "https://www.jetbrains.com/space/?utm_source=product&utm_medium=link&" + PromoKt.getIdePromoUtmParameter() + "&utm_content=13362-space&utm_term=" + placeUtm;
    }

    @NotNull
    public static final String getIdePromoUtmParameter() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        return "utm_campaign=" + buildNumber.getProductCode();
    }

    public static final /* synthetic */ void access$watchPromoVideo(SpaceOverviewPlace overviewPlace) {
        PromoKt.watchPromoVideo(overviewPlace);
    }
}

