/*
 * Decompiled with CFR 0.152.
 */
package circlet.completion.mentions;

import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TeamDirectoryKt;
import circlet.common.mentions.MentionData;
import circlet.completion.mentions.MentionProvider;
import circlet.completion.mentions.MentionProvidersKt;
import circlet.completion.mentions.ProfileMentionTrie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import libraries.collections.Trie;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0002*\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcirclet/completion/mentions/ProfileMentionTrie;", "Llibraries/collections/Trie;", "Lcirclet/common/mentions/MentionData;", "()V", "findAll", "", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "text", "put", "", "profile", "Lcirclet/client/api/TD_MemberProfile;", "remove", "resolve", "clientView", "data", "Companion", "app-state"})
public final class ProfileMentionTrie
extends Trie<MentionData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ProfileMentionTrie.class));

    public ProfileMentionTrie() {
        super(true);
    }

    public final void put(@NotNull TD_MemberProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        MentionData mention = this.data(profile2);
        if (mention != null) {
            this.putName(profile2.getUsername(), mention);
            this.putName(TeamDirectoryKt.englishFullName(profile2), mention);
        }
    }

    public final void remove(@NotNull TD_MemberProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        MentionData mention = this.data(profile2);
        if (mention != null) {
            this.removeName(profile2.getUsername(), mention);
            this.removeName(TeamDirectoryKt.englishFullName(profile2), mention);
        }
    }

    private final MentionData data(TD_MemberProfile $this$data) {
        return ((MentionProvider)MapsKt.getValue(MentionProvidersKt.getMention_providers(), (Object)"p")).data($this$data.getId(), $this$data.getUsername(), TeamDirectoryKt.englishFullName($this$data));
    }

    @NotNull
    public final List<Pair<String, IntRange>> findAll(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List mentions2 = new ArrayList();
        List duplicatedMentions = new ArrayList();
        int maxTextLength = Math.min(text2.length(), 8192);
        Ref.IntRef index = new Ref.IntRef();
        while (index.element < maxTextLength) {
            Pair $dstr$range$found;
            int stoppedAtIx;
            Trie.SearchPrefixResult searchPrefixResult;
            int n;
            if (text2.charAt(index.element) != '@' || ProfileMentionTrie.findAll$isEscaped(index, text2)) {
                n = index.element;
                index.element = n + 1;
                continue;
            }
            n = index.element;
            index.element = n + 1;
            Trie.SearchPrefixResult $dstr$stoppedAtIx$_u24__u24 = searchPrefixResult = this.searchMaxPrefix(text2, index.element, (Function1<Character, Boolean>)((Function1)findAll.1.INSTANCE));
            boolean bl = false;
            index.element = stoppedAtIx = $dstr$stoppedAtIx$_u24__u24.component1();
            if (searchPrefixResult.getResult() == null) continue;
            boolean bl2 = false;
            IntRange range3 = (IntRange)$dstr$range$found.component1();
            List found = (List)$dstr$range$found.component2();
            IntRange rangeWithAt = new IntRange(range3.getFirst() - 1, range3.getLast());
            if (found.size() > 1) {
                ((Collection)duplicatedMentions).add(StringsKt.substring((String)text2, (IntRange)rangeWithAt));
                continue;
            }
            ((Collection)mentions2).add(TuplesKt.to((Object)StringsKt.substring((String)text2, (IntRange)rangeWithAt), (Object)rangeWithAt));
        }
        if (!((Collection)duplicatedMentions).isEmpty()) {
            KLogger this_$iv = log;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn("For " + text2 + " found duplicates " + CollectionsKt.joinToString$default((Iterable)duplicatedMentions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        return mentions2;
    }

    @Nullable
    public final MentionData resolve(@NotNull String clientView2) {
        Intrinsics.checkNotNullParameter((Object)clientView2, (String)"clientView");
        return (MentionData)CollectionsKt.singleOrNull(this.resolveName(clientView2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findAll$isEscaped(Ref.IntRef index, String $text) {
        if (index.element - 1 < 0) return false;
        Character c = Character.valueOf($text.charAt(index.element - 1));
        Character prev = c;
        if (prev == null) return false;
        char c2 = '\\';
        if (prev.charValue() != c2) return false;
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcirclet/completion/mentions/ProfileMentionTrie$Companion;", "", "()V", "log", "Llibraries/klogging/KLogger;", "getLog", "()Llibraries/klogging/KLogger;", "app-state"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

